<?php

namespace Modules\Qbo\Tests;

use App\Models\AccountingTransaction;
use App\Models\Customer;
use App\Models\Product;
use App\Models\Supplier;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Http;

trait QboMockRequests
{
    public function mockGetAccessToken(): void
    {
        Http::fake([
            config('qbo.urlAccessToken') => Http::response(QboTestingData::getAccessToken()),
        ]);
    }

    public function mockRefreshAccounts(): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company*' => Http::response(QboTestingData::getAccounts()),
        ]);
    }

    public function mockRefreshTaxRates(): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company*' => Http::response(QboTestingData::getTaxRates()),
        ]);
    }

    public function mockRefreshTaxCodes(): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company*' => Http::response(QboTestingData::getTaxCodes()),
        ]);
    }

    public function mockRefreshVendors(): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company*' => Http::response(QboTestingData::getVendors()),
        ]);
    }

    public function mockRefreshItems(): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company*' => Http::response(QboTestingData::getItems()),
        ]);
    }

    public function mockUpdateOrCreatePurchaseOrders(Collection $purchaseOrders): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createPurchaseOrders($purchaseOrders)),
        ]);
    }

    public function mockUpdateOrCreateBills(Collection $purchaseInvoices): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createBills($purchaseInvoices)),
        ]);
    }

    public function mockCreateVendor(Supplier $supplier): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/vendor*' => Http::response(QboTestingData::createVendor($supplier)),
        ]);
    }

    public function mockUpdateOrCreateInvoices(Collection $salesOrders): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createInvoices($salesOrders)),
        ]);
    }

    public function mockUpdateOrCreatePayments(Collection $qboRecords, Collection $payments): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createPayments($qboRecords, $payments)),
        ]);
    }

    public function mockDeletePayments(Collection $qboRecords): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::deletePayments($qboRecords)),
        ]);
    }

    public function mockUpdateOrCreateJournals(AccountingTransaction $stockTakeAccountingTransaction): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createJournals($stockTakeAccountingTransaction)),
        ]);
    }

    public function mockUpdateOrCreateCreditMemos(Collection $salesCredits): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/batch*' => Http::response(QboTestingData::createCreditMemos($salesCredits)),
        ]);
    }

    public function mockCreateCustomer(Customer $customer): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/customer*' => Http::response(QboTestingData::createCustomer($customer->name)),
        ]);
    }

    public function mockCreateItem(Product $product): void
    {
        Http::fake([
            '*quickbooks.api.intuit.com/v3/company/*/item*' => Http::response(QboTestingData::createItem($product->sku)),
        ]);
    }
}
