<?php

namespace Modules\Qbo\Tests\Feature;

use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Repositories\QboInvoiceRepository;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class QboTransactionRepositoryTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private QboIntegrationInstance $qboIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->qboIntegrationInstance = QboIntegrationInstance::factory()
            ->has(SalesChannel::factory())
            ->create();
    }

    /**
     * @throws \Throwable
     */
    public function test_it_sync_enabled_sales_order_accounting_transactions(): void
    {
        $amazonIntegrationInstance = AmazonIntegrationInstance::factory([
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => true,
            ],
        ])->hasSalesChannel()->create();

        $salesChannel = $amazonIntegrationInstance->salesChannel;

        SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertEquals(
            1,
            app(QboInvoiceRepository::class)->getTransactionsNeedingUpdate([], SalesOrder::class)->count()
        );
    }

    /**
     * @throws \Throwable
     */
    public function test_it_wont_sync_not_enabled_sales_order_accounting_transactions(): void
    {
        $amazonIntegrationInstance = AmazonIntegrationInstance::factory([
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => false,
            ],
        ])->hasSalesChannel()->create();

        $salesChannel = $amazonIntegrationInstance->salesChannel;

        SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertEquals(
            0,
            app(QboInvoiceRepository::class)->getTransactionsNeedingUpdate([], SalesOrder::class)->count()
        );
    }
}