<?php

namespace Modules\Qbo\Services;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Enums\HttpMethodEnum;
use Exception;
use Modules\Qbo\ApiParameterObjects\QboCreateItemApo;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\ApiParameterObjects\QboQueryItemApo;
use Modules\Qbo\Data\QboItemData;
use Modules\Qbo\Data\QboResponseData;

class QboItemClient extends QboAuthenticationClient
{
    public function __construct(IntegrationInstanceInterface $integrationInstance)
    {
        parent::__construct($integrationInstance);
    }

    public function getItems(QboQueryItemApo|QboQueryApo $parameters): QboResponseData
    {
        return $this->getData('Item', QboItemData::class, $parameters);
    }

    public function createItem(QboCreateItemApo $parameters): QboResponseData
    {
        $response = $this->request(
            HttpMethodEnum::POST,
            '/item',
            $parameters->transform()
        );

        if ($response->ok()) {
            return QboResponseData::from([
                'collection' => collect([
                    QboItemData::from($response->json()['Item']),
                ]),
            ]);
        } elseif ($response->status() === 400 && @$response->json()['Fault']['Error'][0]['Message'] == 'Duplicate Name Exists Error') {
            return $this->getItems(new QboQueryItemApo($parameters->Name));
        } else {
            throw new Exception('Error while creating the item:'.json_encode($response->json()), 1);
        }
    }
}
