<?php

namespace Modules\Qbo\Services;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Enums\HttpMethodEnum;
use Exception;
use Modules\Qbo\ApiParameterObjects\QboCreateCustomerApo;
use Modules\Qbo\ApiParameterObjects\QboQueryCustomerApo;
use Modules\Qbo\Data\QboCustomerData;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Exceptions\QboSystemFailureException;

class QboCustomerClient extends QboAuthenticationClient
{
    public function __construct(IntegrationInstanceInterface $integrationInstance)
    {
        parent::__construct($integrationInstance);
    }

    public function getCustomers(QboQueryCustomerApo $parameters): QboResponseData
    {
        return $this->getData('Customer', QboCustomerData::class, $parameters);
    }

    public function createCustomer(QboCreateCustomerApo $parameters): QboResponseData
    {
        $response = $this->request(
            HttpMethodEnum::POST,
            '/customer',
            $parameters->transform()
        );

        if ($response->ok()) {
            return QboResponseData::from([
                'collection' => collect([
                    QboCustomerData::from(array_merge($response->json()['Customer'], [
                        'json_object' => $response->json()['Customer'],
                    ])),
                ]),
            ]);
        } else {
            //Sometimes QBO returns fault instead of Fault
            $json = @$response->json()['Fault'] ?? @$response->json()['fault'];

            if ($response->status() === 400 && (@$json['Error'][0]['Message'] == 'Duplicate Name Exists Error' || @$json['error'][0]['message'] == 'Duplicate Name Exists Error')) {
                return $this->getCustomers(new QboQueryCustomerApo($parameters->displayName));
            } elseif (@$response->json()['Fault']['Error'][0]['Message'] == 'An application error has occurred while processing your request') {
                throw new QboSystemFailureException();
            } else {
                throw new Exception(json_encode($response->json()), 1);
            }
        }
    }
}
