<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Abstractions\Integrations\Accounting\AccountingTaxRateRepositoryInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Modules\Qbo\Entities\QboTaxRate;

class QboTaxRateRepository extends AbstractIntegrationRepository implements AccountingTaxRateRepositoryInterface
{
    public function getModelClassName(): string
    {
        return QboTaxRate::class;
    }

    public function getStartDateField(): string
    {
        return 'LastUpdatedTimeUtc';
    }

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon
    {
        return Carbon::now();
    }
}
