<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Abstractions\Integrations\Accounting\AccountingProductRepositoryInterface;
use Modules\Qbo\Entities\QboItem;

class QboItemRepository extends AbstractIntegrationRepository implements AccountingProductRepositoryInterface
{
    public function getModelClassName(): string
    {
        return QboItem::class;
    }

    public function getQboProductByName(string $name): ?QboItem
    {
        return QboItem::where('Name', $name)->first();
    }

    public function getTaxPayableItem(): ?QboItem
    {
        return QboItem::where('Name', QboItem::TAX_PAYABLE_ITEM)->first();
    }
}
