<?php

namespace Modules\Qbo\Repositories;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Abstractions\Integrations\Accounting\AccountingAccountRepositoryInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Modules\Qbo\Entities\QboAccount;

class QboAccountRepository extends AbstractIntegrationRepository implements AccountingAccountRepositoryInterface
{
    public function getModelClassName(): string
    {
        return QboAccount::class;
    }

    /*
     * TODO: @Bright: Do the next 4 methods belong in the model instead?  That way we can just specify the model class and then rely on the model for the other 4 methods.
     */

    public function getUniqueJsonId(): string
    {
        return 'Id';
    }

    public function getStartDateField(): string
    {
        return 'LastUpdatedTimeUtc';
    }

    public function useIntegrationInstance(): bool
    {
        return false;
    }

    public function getAccountsPayableAccount(): ?QboAccount
    {
        return QboAccount::where('AccountType', 'Accounts Payable')->first();
    }

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon
    {
        return Carbon::now();
    }

    public function getAccountsWithoutNominalCodesIn(array $ids): Collection
    {
        return QboAccount::leftJoinRelationship('nominalCode')
            ->whereNull('nominal_codes.id')
            ->whereIn('qbo_accounts.id', $ids)
            ->get();
    }
}
