<?php

namespace Modules\Qbo\Manager;

use App\Abstractions\Integrations\Accounting\AbstractAccountingManager;
use App\Abstractions\Integrations\Accounting\AccountingAccountRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingBillRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingContactRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingCustomerRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingInvoiceRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingJournalRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingPaymentRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingProductRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingPurchaseOrderRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingSalesCreditRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingTaxCodeRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingTaxRateRepositoryInterface;
use App\Abstractions\Integrations\Accounting\AccountingVendorRepositoryInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\AccountingTransaction;
use App\Models\SalesOrder;
use App\Repositories\Accounting\AccountingTransactionRepository;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\LazyCollection;
use Modules\Qbo\ApiParameterObjects\QboDeletePaymentsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateBillsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateInvoicesApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateJournalsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePaymentsApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePurchaseOrdersApo;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Jobs\QboDeletePaymentsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateBillsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateCreditMemosJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateInvoicesJob;
use Modules\Qbo\Jobs\QboUpdateOrCreateJournalsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreatePaymentsJob;
use Modules\Qbo\Jobs\QboUpdateOrCreatePurchaseOrdersJob;
use Modules\Qbo\Repositories\QboAccountRepository;
use Modules\Qbo\Repositories\QboBillRepository;
use Modules\Qbo\Repositories\QboContactRepository;
use Modules\Qbo\Repositories\QboCreditMemoRepository;
use Modules\Qbo\Repositories\QboCustomerRepository;
use Modules\Qbo\Repositories\QboInvoiceRepository;
use Modules\Qbo\Repositories\QboItemRepository;
use Modules\Qbo\Repositories\QboJournalRepository;
use Modules\Qbo\Repositories\QboPaymentRepository;
use Modules\Qbo\Repositories\QboPurchaseOrderRepository;
use Modules\Qbo\Repositories\QboTaxCodeRepository;
use Modules\Qbo\Repositories\QboTaxRateRepository;
use Modules\Qbo\Repositories\QboVendorRepository;
use Modules\Qbo\Services\QboClient;

class QboManager extends AbstractAccountingManager
{
    protected AccountingAccountRepositoryInterface $accounts;

    protected AccountingContactRepositoryInterface $contacts;

    protected AccountingTaxRateRepositoryInterface $taxRates;

    protected AccountingTaxCodeRepositoryInterface $taxCodes;

    protected AccountingPaymentRepositoryInterface $payments;

    protected AccountingVendorRepositoryInterface $vendors;

    protected AccountingCustomerRepositoryInterface $customers;

    protected AccountingPurchaseOrderRepositoryInterface $purchaseOrders;

    protected AccountingBillRepositoryInterface $bills;

    protected AccountingInvoiceRepositoryInterface $invoices;

    protected AccountingSalesCreditRepositoryInterface $creditMemos;

    protected AccountingJournalRepositoryInterface $journals;

    protected AccountingProductRepositoryInterface $items;

    private AccountingTransactionRepository $accountingTransactions;

    /**
     * @throws Exception
     */
    public function __construct(protected QboIntegrationInstance|IntegrationInstanceInterface $integrationInstance)
    {
        $this->accounts = app(QboAccountRepository::class);
        $this->contacts = app(QboContactRepository::class);
        $this->taxRates = app(QboTaxRateRepository::class);
        $this->payments = app(QboPaymentRepository::class);
        $this->creditMemos = app(QboCreditMemoRepository::class);
        $this->vendors = app(QboVendorRepository::class);
        $this->customers = app(QboCustomerRepository::class);
        $this->purchaseOrders = app(QboPurchaseOrderRepository::class);
        $this->bills = app(QboBillRepository::class);
        $this->invoices = app(QboInvoiceRepository::class);
        $this->items = app(QboItemRepository::class);
        $this->journals = app(QboJournalRepository::class);
        $this->accountingTransactions = app(AccountingTransactionRepository::class);
        $this->taxCodes = app(QboTaxCodeRepository::class);

        parent::__construct(
            $integrationInstance,
            $this->accounts,
            $this->contacts,
            $this->taxRates,
            $this->taxCodes,
            $this->vendors,
            $this->items,
            $this->customers,
            $this->purchaseOrders,
            $this->bills,
            $this->invoices,
            $this->payments,
            $this->creditMemos,
            $this->journals,
            new QboClient($integrationInstance)
        );
    }

    public function makeTransactionJob(string $type, LazyCollection $transactions)
    {
        switch ($type) {
            case AccountingTransaction::TYPE_PURCHASE_ORDER:
                return new QboUpdateOrCreatePurchaseOrdersJob($this->integrationInstance, new QboUpdateOrCreatePurchaseOrdersApo($transactions));
                break;

            case AccountingTransaction::TYPE_PURCHASE_ORDER_INVOICE:
                return new QboUpdateOrCreateBillsJob($this->integrationInstance, new QboUpdateOrCreateBillsApo($transactions));
                break;

            case AccountingTransaction::TYPE_SALES_ORDER_INVOICE:
                return new QboUpdateOrCreateInvoicesJob($this->integrationInstance, new QboUpdateOrCreateInvoicesApo($transactions));
                break;

            case AccountingTransaction::TYPE_SALES_CREDIT:
                return new QboUpdateOrCreateCreditMemosJob($this->integrationInstance, new QboUpdateOrCreateInvoicesApo($transactions));
                break;

            case AccountingTransaction::TYPE_STOCK_TAKE:
                return new QboUpdateOrCreateJournalsJob($this->integrationInstance, new QboUpdateOrCreateJournalsApo($transactions));
                break;

            case AccountingTransaction::TYPE_INVENTORY_ADJUSTMENT:
                return new QboUpdateOrCreateJournalsJob($this->integrationInstance, new QboUpdateOrCreateJournalsApo($transactions));
                break;

            case AccountingTransaction::TYPE_CUSTOMER_RETURN:
                return new QboUpdateOrCreateJournalsJob($this->integrationInstance, new QboUpdateOrCreateJournalsApo($transactions));
                break;

            case AccountingTransaction::TYPE_SALES_ORDER_FULFILLMENT:
                return new QboUpdateOrCreateJournalsJob($this->integrationInstance, new QboUpdateOrCreateJournalsApo($transactions));
                break;

            case AccountingTransaction::TYPE_PURCHASE_ORDER_RECEIPT:
                return new QboUpdateOrCreateJournalsJob($this->integrationInstance, new QboUpdateOrCreateJournalsApo($transactions));
                break;

            default:
                throw new Exception('Missing type', 1);
                break;
        }
    }

    public function makePaymentJob(string $type, Collection $payments)
    {
        switch ($type) {
            case SalesOrder::class:
                return new QboUpdateOrCreatePaymentsJob($this->integrationInstance, new QboUpdateOrCreatePaymentsApo($payments));
                break;

            default:
                throw new Exception('Missing type', 1);
                break;
        }
    }

    public function makeDeletePaymentJob(Collection $payments)
    {
        return new QboDeletePaymentsJob($this->integrationInstance, new QboDeletePaymentsApo($payments));
    }
}
