<?php

namespace Modules\Qbo\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboQueryPurchaseOrderApo;
use Modules\Qbo\Data\QboResponseData;

class QboUpdateOrCreatePurchaseOrdersJob extends QboUpdateOrCreateExpenseJob implements ShouldBeEncrypted, ShouldBeUnique
{
    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $this->syncVendors();
        $this->syncProducts();

        $response = $this->qboManager->syncPurchaseOrders($this->parameters);

        if ($response->syncTokenErrors && $response->syncTokenErrors->isNotEmpty()) {
            foreach ($response->syncTokenErrors->pluck('PurchaseOrder')->pluck('Id')->values()->toArray() as $purchaseId) {
                $this->qboManager->fetchPurchaseOrders(new QboQueryPurchaseOrderApo([$purchaseId]));
            }
        }

        return $response;
    }
}
