<?php

namespace Modules\Qbo\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboQueryPaymentApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreatePaymentsApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboUpdateOrCreatePaymentsJob extends QboJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        protected QboIntegrationInstance $integrationInstance,
        protected QboUpdateOrCreatePaymentsApo $parameters
    ) {
        $this->onQueue('accounting');
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $response = (new QboManager($this->integrationInstance))->syncInvoicePayments($this->parameters);

        if ($response->errors && $response->syncTokenErrors->isNotEmpty()) {
            foreach ($response->syncTokenErrors->pluck('Payment')->pluck('Id')->values()->toArray() as $paymentId) {
                (new QboManager($this->integrationInstance))->fetchPayments(new QboQueryPaymentApo([$paymentId]));
            }
        }

        return $response;
    }
}
