<?php

namespace Modules\Qbo\Jobs;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\AccountingTransaction;
use App\Models\AccountingTransactionLine;
use App\Models\FinancialLine;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboQueryInvoiceApo;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateInvoicesApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboItem;

class QboUpdateOrCreateInvoicesJob extends QboUpdateOrCreateSaleJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        QboIntegrationInstance $integrationInstance,
        QboUpdateOrCreateInvoicesApo|ApiDataTransformerInterface $parameters
    ) {
        parent::__construct($integrationInstance, $parameters);
    }

    public function syncProducts()
    {
        $productNames = collect();

        $this->parameters->accountingTransactions->each(function (AccountingTransaction $accountingTransaction) use (&$productNames) {
            $accountingTransaction->accountingTransactionLines->each(function (AccountingTransactionLine $accountingTransactionLine) use (&$productNames) {
                $hasMissingSku = true;

                if ($accountingTransactionLine->link?->product?->sku) {
                    $productNames->push($accountingTransactionLine->link?->product?->sku);
                } elseif ($accountingTransactionLine->link_type === FinancialLine::class) {
                    $productNames->push($accountingTransactionLine->description);
                } elseif (! $hasMissingSku) {
                    $productNames->push(QboItem::MISSING_SKU);
                }
            });
        });

        //Create taxable item
        if ($this->integrationInstance->isTaxPayableSeparated()) {
            $productNames->push(QboItem::TAX_PAYABLE_ITEM);
        }

        //Make sure product exists
        $this->qboManager->syncProducts($productNames->toArray());
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $this->syncCustomers();
        $this->syncProducts();

        $response = $this->qboManager->syncInvoices($this->parameters);

        if ($response->errors && $response->syncTokenErrors->isNotEmpty()) {
            foreach ($response->syncTokenErrors->pluck('Invoice')->pluck('Id')->values()->toArray() as $qboInvoiceId) {
                $this->qboManager->refreshInvoices(new QboQueryInvoiceApo([$qboInvoiceId]));
            }
        }

        return $response;
    }
}
