<?php

namespace Modules\Qbo\Jobs;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\AccountingTransaction;
use App\Models\AccountingTransactionLine;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboUpdateOrCreateCreditMemosApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboUpdateOrCreateCreditMemosJob extends QboUpdateOrCreateSaleJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        QboIntegrationInstance $integrationInstance,
        QboUpdateOrCreateCreditMemosApo|ApiDataTransformerInterface $parameters
    ) {
        parent::__construct($integrationInstance, $parameters);
    }

    public function syncProducts()
    {
        $productNames = collect();

        $this->parameters->accountingTransactions->each(function (AccountingTransaction $accountingTransaction) use (&$productNames) {
            $accountingTransaction->accountingTransactionLines->each(function (AccountingTransactionLine $accountingTransactionLine) use (&$productNames) {
                if ($accountingTransactionLine->link?->product?->sku) {
                    $productNames->push($accountingTransactionLine->link?->product?->sku);
                }

            });
        });

        //Make sure product exists
        $this->qboManager->syncProducts($productNames->toArray());
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $this->syncProducts();
        $this->syncCustomers();

        return (new QboManager($this->integrationInstance))->syncSalesCredits($this->parameters);
    }
}
