<?php

namespace Modules\Qbo\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\Data\QboResponseData;

class QboUpdateOrCreateBillsJob extends QboUpdateOrCreateExpenseJob implements ShouldBeEncrypted, ShouldBeUnique
{
    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $this->syncVendors();

        return $this->qboManager->syncBills($this->parameters);
    }
}
