<?php

namespace Modules\Qbo\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Qbo\ApiParameterObjects\QboDeletePaymentsApo;
use Modules\Qbo\Data\QboResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboDeletePaymentsJob extends QboJob implements ShouldBeEncrypted, ShouldBeUnique
{
    public function __construct(
        protected QboIntegrationInstance $integrationInstance,
        private QboDeletePaymentsApo $parameters
    ) {
        $this->onQueue('accounting');
    }

    /**
     * Execute the job.
     *
     * @return void
     *
     * @throws Exception
     */
    public function apiCall(): QboResponseData
    {
        $response = (new QboManager($this->integrationInstance))->syncDeletePayments($this->parameters);

        return $response;
    }
}
