<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\Integrations\Accounting\AbstractAccountingTransactionController;
use App\Response;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Manager\QboManager;

class QboTransactionController extends AbstractAccountingTransactionController
{
    public function syncTransactions(QboIntegrationInstance $integrationInstance): Response
    {
        (new QboManager($integrationInstance))->syncTransactions();

        return $this->response->setMessage('Added to queue, purchase orders will be refreshed shortly.');
    }

    public function syncPayments(QboIntegrationInstance $integrationInstance): Response
    {
        (new QboManager($integrationInstance))->syncPayments();

        return $this->response->setMessage('Added to queue, purchase orders will be refreshed shortly.');
    }

    public function deletePayments(QboIntegrationInstance $integrationInstance): Response
    {
        (new QboManager($integrationInstance))->deletePayments();

        return $this->response->setMessage('Added to queue, purchase orders will be refreshed shortly.');
    }
}
