<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\Integrations\Accounting\AbstractAccountingTaxRateController;
use App\Response;
use Illuminate\Http\Request;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Entities\QboTaxRate;
use Modules\Qbo\Http\Resources\QboTaxRateResource;
use Modules\Qbo\Jobs\RefreshQboTaxRatesJob;

class QboTaxRateController extends AbstractAccountingTaxRateController
{
    public function getModel(): string
    {
        return QboTaxRate::class;
    }

    public function getResource(): string
    {
        return QboTaxRateResource::class;
    }

    /**
     * @throws Throwable
     */
    public function refresh(QboIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshQboTaxRatesJob($integrationInstance, new QboQueryApo()));
    }

    public function indexForIntegration(Request $request, QboIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }
}
