<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\AbstractOauthAuthenticationCallbackCallbackController;
use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Response;
use Exception;
use Illuminate\Http\RedirectResponse;
use Modules\Qbo\Data\QboAuthorizationResponseData;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Repositories\QboIntegrationInstanceRepository;
use Modules\Qbo\Services\QboClient;

class QboAuthenticationController extends AbstractOauthAuthenticationCallbackCallbackController
{
    public function getIntegrationInstanceRepository(): AbstractIntegrationInstanceRepository
    {
        return app(QboIntegrationInstanceRepository::class);
    }

    /**
     * @throws Exception
     */
    public function getClient(IntegrationInstanceInterface $integrationInstance): IntegrationClientInterface
    {
        return new QboClient($integrationInstance);
    }

    public function getStateParameterName(): string
    {
        return 'state';
    }

    /**
     * @throws Exception
     */
    public function getRedirectUrl(QboIntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData((new QboClient($integrationInstance))->getRedirectUrl());
    }

    /**
     * @throws Exception
     */
    public function callback(QboAuthorizationResponseData $data): RedirectResponse
    {
        /** @var QboIntegrationInstance $integrationInstance */
        $integrationInstance = parent::abstractCallback($data);

        return redirect("/integrations/quickbooks-online/{$integrationInstance->id}/dashboard");
    }
}
