<?php

namespace Modules\Qbo\Http\Controllers;

use App\Abstractions\Integrations\Accounting\AbstractAccountingAccountController;
use App\Response;
use Illuminate\Http\Request;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Entities\QboAccount;
use Modules\Qbo\Entities\QboIntegrationInstance;
use Modules\Qbo\Http\Requests\StoreNominalCodeRequest;
use Modules\Qbo\Http\Resources\QboAccountResource;
use Modules\Qbo\Jobs\RefreshQboAccountsJob;
use Modules\Qbo\Manager\QboManager;

class QboAccountController extends AbstractAccountingAccountController
{
    public function getModel(): string
    {
        return QboAccount::class;
    }

    public function getResource(): string
    {
        return QboAccountResource::class;
    }

    /**
     * @throws Throwable
     */
    public function refresh(QboIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshQboAccountsJob($integrationInstance, new QboQueryApo()));
    }

    public function indexForIntegration(Request $request, QboIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }

    public function createNominalCodes(StoreNominalCodeRequest $request, QboIntegrationInstance $integrationInstance): Response
    {
        (new QboManager($integrationInstance))->createNominalCodes($request->validated()['ids']);

        return $this->response->setMessage('Create nominal codes successfully.');
    }
}
