<?php

namespace Modules\Qbo\Enums;

use App\Models\NominalCode;

enum QboAccountTypeEnum: string
{
    case BANK = 'Bank';
    case OTHER_CURRENT_ASSET = 'Other Current Asset';
    case FIXED_ASSET = 'Fixed Asset';
    case OTHER_ASSET = 'Other Asset';
    case ACCOUNTS_RECEIVABLE = 'Accounts Receivable';
    case EQUITY = 'Equity';
    case EXPENSE = 'Expense';
    case OTHER_EXPENSE = 'Other Expense';
    case COST_OF_GOODS_SOLD = 'Cost of Goods Sold';
    case ACCOUNTS_PAYABLE = 'Accounts Payable';
    case CREDIT_CARD = 'Credit Card';
    case LONG_TERM_LIABILITY = 'Long Term Liability';
    case OTHER_CURRENT_LIABILITY = 'Other Current Liability';
    case INCOME = 'Income';
    case OTHER_INCOME = 'Other Income';

    public function toNominalCodeType(): string
    {
        return match ($this) {
            self::BANK, self::CREDIT_CARD => NominalCode::TYPE_BANK,
            self::OTHER_CURRENT_ASSET, self::ACCOUNTS_RECEIVABLE => NominalCode::TYPE_CURRENT,
            self::FIXED_ASSET => NominalCode::TYPE_FIXED,
            self::OTHER_ASSET => NominalCode::TYPE_ASSET,
            self::EQUITY => NominalCode::TYPE_EQUITY,
            self::EXPENSE, self::COST_OF_GOODS_SOLD, self::OTHER_EXPENSE => NominalCode::TYPE_EXPENSE,
            self::ACCOUNTS_PAYABLE, self::OTHER_CURRENT_LIABILITY => NominalCode::TYPE_CURRLIAB,
            self::LONG_TERM_LIABILITY => NominalCode::TYPE_LIABILITY,
            self::INCOME, self::OTHER_INCOME => NominalCode::TYPE_REVENUE,
        };
    }
}
