<?php

namespace Modules\Qbo\Entities;

use App\Abstractions\Integrations\Accounting\AbstractAccountingVendor;
use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Kirschbaum\PowerJoins\PowerJoins;

/**
 * @property int $id
 * @property string $QboId
 * @property string $DisplayName
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboVendor extends QboModel implements AbstractAccountingVendor
{
    use BulkImport;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    public function link(): MorphTo
    {
        return $this->morphTo();
    }
}
