<?php

namespace Modules\Qbo\Entities;

use App\Enums\AccountingTransactionTypeEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;

/**
 * Class QboTransaction.
 *
 * @property int $id
 * @property string $uuid
 * @property string $type
 * @property array $last_error
 * @property array $json_object
 * @property array $request_body
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class QboTransaction extends QboModel
{
    use HasFactory;

    protected $casts = [
        'type' => AccountingTransactionTypeEnum::class,
        'last_error' => 'array',
        'json_object' => 'array',
        'request_body' => 'array',
    ];
}
