<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kirschbaum\PowerJoins\PowerJoins;
use Modules\Qbo\Database\factories\QboTaxRateFactory;

/**
 * @property int $id
 * @property string $QboId
 * @property string $Name
 * @property string $Description
 * @property bool $Active
 * @property float $RateValue
 * @property array $AgencyRef
 * @property string $SpecialTaxType
 * @property string $DisplayType
 * @property string $domain
 * @property bool $sparse
 * @property string $SyncToken
 * @property array $MetaData
 * @property Carbon $LastUpdatedTimeUtc
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboTaxRate extends QboModel implements Filterable
{
    use HasFactory;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    protected $guarded = [];

    protected $casts = [
        'Active' => 'boolean',
        'sparse' => 'boolean',
        'MetaData' => 'array',
        'AgencyRef' => 'array',
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */
    public static function newFactory(): Factory
    {
        return QboTaxRateFactory::new();
    }
}
