<?php

namespace Modules\Qbo\Entities;

use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use Carbon\Carbon;
use Kirschbaum\PowerJoins\PowerJoins;

/**
 * @property int $id
 * @property string $QboId
 * @property string $Name
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class QboItem extends QboModel
{
    use BulkImport;
    use HasFilters;
    use PowerJoins;

    const BULK_THRESHOLD = 1;

    const MISSING_SKU = 'UNKNOWN';

    const TAX_PAYABLE_ITEM = 'Tax Payable';

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];
}
