<?php

namespace Modules\Qbo\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Modules\Qbo\Database\factories\QboContactFactory;

/**
 * @property int $id
 * @property string $contactId
 * @property string $contactType
 * @property string $DisplayName
 * @property int $link_id
 * @property string $link_type
 * @property array $last_error
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class QboContact extends QboModel
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'last_error' => 'array',
    ];

    public function link(): MorphTo
    {
        return $this->morphTo('link');
    }

    public function lastSyncedAt(): Attribute
    {
        return Attribute::get(fn () => $this->updated_at);
    }

    public function getLastSyncedAt(): ?Carbon
    {
        return $this->last_synced_at;
    }

    public function getLastError(): ?array
    {
        return $this->last_error;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }

    public static function newFactory(): Factory
    {
        return QboContactFactory::new();
    }
}
