<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('qbo_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('QboId')->unique()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Id'))");
            $table->string('Name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Name'))");
            $table->string('FullyQualifiedName')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FullyQualifiedName'))");
            $table->string('AccountType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.AccountType'))");
            $table->string('AccountSubType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.AccountSubType'))");
            $table->string('Active')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Active'))");
            $table->string('Classification')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Classification'))");
            $table->string('LastUpdatedTime')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.MetaData.LastUpdatedTime'))");
            $table->dateTime('LastUpdatedTimeUtc')->storedAs("STR_TO_DATE(JSON_UNQUOTE(json_extract(json_object,'$.LastUpdatedTimeUtc')),'%Y-%m-%d %H:%i:%s')");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('qbo_accounts');
    }
};
