<?php

namespace Modules\Qbo\Data;

use App\Abstractions\Integrations\Data\OauthRefreshTokenResponseData;
use Illuminate\Support\Optional;

class QboOauthRefreshTokenResponseData extends OauthRefreshTokenResponseData
{
    public function __construct(
        public string $refresh_token,
        public string $access_token,
        public string $token_type,
        public int $x_refresh_token_expires_in,
        public int $expires_in,
        public Optional|int|null $expiresAccessToken = null,
        public Optional|int|null $expiresRefreshToken = null,
    ) {
        parent::__construct($refresh_token, $access_token);

        $this->expiresAccessToken = $this->expires_in + time();
        $this->expiresRefreshToken = $this->x_refresh_token_expires_in + time();
    }
}
