<?php

namespace Modules\Qbo\Data;

use App\Abstractions\Integrations\Data\AbstractJsonObjectData;
use Carbon\Carbon;

class QboBaseData extends AbstractJsonObjectData
{
    public function __construct(
        public array $json_object,
        public ?string $QboId
    ) {
        $this->QboId = @$this->json_object['Id'];

        //Set LastUpdatedTimeUtc
        if (@$this->json_object['MetaData']['LastUpdatedTime']) {
            $this->json_object['LastUpdatedTimeUtc'] = $this->json_object['MetaData']['LastUpdatedTime'] ? Carbon::parse($this->json_object['MetaData']['LastUpdatedTime'])->setTimezone('UTC')->toDateTimeString() : null;
        }
    }
}
