<?php

namespace Modules\Qbo\Console;

use App\Models\PurchaseOrder;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboPurchaseOrdersCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:purchase-orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync purchase orders.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions([], PurchaseOrder::class, 30);
    }
}
