<?php

namespace Modules\Qbo\Console;

use App\Models\InventoryAdjustment;
use App\Models\SalesOrderFulfillment;
use App\Models\StockTake;
use App\Repositories\IntegrationInstanceRepository;
use App\Services\Amazon\FBAInventory\CustomerReturn;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboJournalsCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:journals';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync stock takes, inventory adjustments, customer return, sales order fulfillment.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        foreach ([
            StockTake::class,
            InventoryAdjustment::class,
            CustomerReturn::class,
            SalesOrderFulfillment::class,
        ] as $modelType) {
            (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions([], $modelType, 30);
        }

    }
}
