<?php

namespace Modules\Qbo\Console;

use App\Models\SalesOrder;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboInvoicePaymentsCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:invoice-payments';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync sales order payments.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncPayments([], SalesOrder::class, 30);
    }
}
