<?php

namespace Modules\Qbo\Console;

use App\Models\PurchaseInvoice;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncQboBillsCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:bills';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync purchase invoices.';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions([], PurchaseInvoice::class, 30);
    }
}
