<?php

namespace Modules\Qbo\Console;

use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Manager\QboManager;

class SyncAccountingTransactionsCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:sync:accounting-transactions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh QuickBooks Online Accounts';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        ( new QboManager($this->integrationInstanceRepository->getQboAccountingInstance()))->syncTransactions();
    }
}
