<?php

namespace Modules\Qbo\Console;

use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\ApiParameterObjects\QboQueryApo;
use Modules\Qbo\Jobs\RefreshQboAccountsJob;

class RefreshQboAccountsCommand extends Command
{
    public function __construct(private readonly IntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:accounts:refresh {--lastUpdatedAfter=} {--days=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh QuickBooks Online Accounts';

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        $parameters = new QboQueryApo();

        RefreshQboAccountsJob::dispatch(
            $this->integrationInstanceRepository->getQboAccountingInstance(),
            $parameters,
        )->onQueue('accounting');
    }
}
