<?php

namespace Modules\Qbo\Console;

use Exception;
use Illuminate\Console\Command;
use Modules\Qbo\Repositories\QboIntegrationInstanceRepository;
use Modules\Qbo\Services\QboAuthenticationClient;

class InitializeQboIntegrationInstanceCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'qbo:initialize';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create Quickbooks Online integration instance and provide authorization URL';

    /**
     * @throws Exception
     */
    public function handle(
        QboIntegrationInstanceRepository $qboIntegrationInstanceRepository,
    ): void {
        $integrationInstance = $qboIntegrationInstanceRepository->initialize();

        $this->line("Visit the following URL to complete the setup:\n");
        $this->line((new QboAuthenticationClient($integrationInstance))->getRedirectUrl());
    }
}
