<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\AccountingTransaction;
use App\Models\AccountingTransactionLine;
use Illuminate\Support\LazyCollection;
use Modules\Qbo\Data\QboCreateCreditMemoLineData;
use Modules\Qbo\Data\QboCreateCreditMemosData;
use Modules\Qbo\Entities\QboCustomer;
use Modules\Qbo\Repositories\QboAccountRepository;
use Modules\Qbo\Repositories\QboCustomerRepository;
use Modules\Qbo\Repositories\QboItemRepository;

class QboUpdateOrCreateCreditMemosApo implements ApiDataTransformerInterface
{
    public QboAccountRepository $accounts;

    public QboCustomerRepository $customers;

    public QboItemRepository $items;

    public function __construct(
        public LazyCollection $accountingTransactions
    ) {
        $this->customers = app(QboCustomerRepository::class);
        $this->items = app(QboItemRepository::class);
    }

    public function transform(): array
    {
        $creditMemos = [];

        $this->accountingTransactions->each(function (AccountingTransaction $accountingTransaction) use (&$creditMemos) {
            $lineItems = [];

            $accountingTransaction->accountingTransactionLines->each(function (AccountingTransactionLine $accountingTransactionLine) use (&$creditMemos, $accountingTransaction, &$lineItems) {
                $amount = $accountingTransactionLine->amount +
                        ($accountingTransaction->is_tax_included && $accountingTransactionLine->quantity != 0 ?
                            ($accountingTransactionLine->tax_amount / $accountingTransactionLine->quantity) : 0);

                // Look up specs of posting purchase orders... create a dto and build it here or get from a model?
                $lineItems[] = QboCreateCreditMemoLineData::from([
                    'Description' => $accountingTransactionLine->description,
                    'DetailType' => 'SalesItemLineDetail',
                    'Amount' => $amount,
                    'SalesItemLineDetail' => [
                        'ItemRef' => [
                            'value' => $this->items->getQboProductByName($accountingTransactionLine->link->product->sku)->QboId,
                        ],
                    ],

                ])->toArray();
            });

            $data = QboCreateCreditMemosData::from([
                'DocNumber' => $accountingTransaction->link->sales_credit_number,
                'CustomerRef' => [
                    'value' => $accountingTransaction->link->customer?->name ? $this->customers->getQboCustomerByDisplayName($accountingTransaction->link->customer->name)?->QboId : $this->customers->getQboCustomerByDisplayName(QboCustomer::MISSING_CUSTOMER_NAME)->QboId,
                ],
                'CurrencyRef' => [
                    'value' => $accountingTransaction->currency_code,
                ],
                'Line' => $lineItems,
            ]);

            if ($QboId = $accountingTransaction->accountingIntegration?->QboId) {
                $data->Id = $QboId;
                $data->SyncToken = $accountingTransaction->accountingIntegration->json_object['SyncToken'];
            }

            $creditMemos[] = $data->toArray();
        });

        $params = [
            'records' => $creditMemos,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
