<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Models\AccountingTransaction;
use App\Models\AccountingTransactionLine;
use Illuminate\Support\LazyCollection;
use Modules\Qbo\Data\QboCreateBillData;
use Modules\Qbo\Data\QboCreateBillLineData;
use Modules\Qbo\Entities\QboItem;
use Modules\Qbo\Repositories\QboAccountRepository;
use Modules\Qbo\Repositories\QboVendorRepository;

class QboUpdateOrCreateBillsApo implements ApiDataTransformerInterface
{
    public QboAccountRepository $accounts;

    public QboVendorRepository $vendors;

    public function __construct(
        public LazyCollection $accountingTransactions
    ) {
        $this->accounts = app(QboAccountRepository::class);
        $this->vendors = app(QboVendorRepository::class);
    }

    public function transform(): array
    {
        $bills = [];

        $addSeparateTaxLine = true; //TODO: Optimize

        $this->accountingTransactions->each(function (AccountingTransaction $accountingTransaction) use (&$bills, $addSeparateTaxLine) {
            $lineItems = [];
            $linkedPurchaseOrders = [];
            $salesTax = 0;

            //Link purchase orders with bills
            if ($qboPurchaseOrder = $accountingTransaction->link->purchaseOrder?->accountingTransaction?->accountingIntegration) {
                $linkedPurchaseOrders[] = [
                    'TxnId' => $qboPurchaseOrder->QboId,
                    'TxnType' => 'PurchaseOrder',
                ];
            }

            $accountingTransaction->accountingTransactionLines->each(function (AccountingTransactionLine $accountingTransactionLine) use ($addSeparateTaxLine, $accountingTransaction, &$lineItems, &$salesTax) {
                $amount = $addSeparateTaxLine ? $accountingTransactionLine->getAmountWithoutTax($accountingTransaction->is_tax_included) : $accountingTransactionLine->getAmountWithTax($accountingTransaction->is_tax_included);

                // Look up specs of posting purchase orders... create a dto and build it here or get from a model?
                $lineItems[] = QboCreateBillLineData::from([
                    'Description' => $accountingTransactionLine->description,
                    'AccountBasedExpenseLineDetail' => [
                        // 'Qty' => $accountingTransactionLine->quantity,
                        'AccountRef' => [
                            'value' => $accountingTransactionLine->nominalCode->code,
                        ],
                    ],
                    'DetailType' => 'AccountBasedExpenseLineDetail',
                    // TODO: Not sure if amount is per unit or total
                    'Amount' => $amount * $accountingTransactionLine->quantity,

                ])->toArray();

                if ($addSeparateTaxLine) {
                    $salesTax = $salesTax + $accountingTransactionLine->getTaxAmount($accountingTransaction->is_tax_included);
                }
            });

            //Pick tax rate for first sales order line items
            if ($addSeparateTaxLine) {
                $lineItems[] = QboCreateBillLineData::from([
                    'Description' => QboItem::TAX_PAYABLE_ITEM,
                    'AccountBasedExpenseLineDetail' => [
                        'AccountRef' => [
                            'value' => $accountingTransaction->accountingTransactionLines->first()->nominalCode->code,
                        ],
                    ],
                    'DetailType' => 'AccountBasedExpenseLineDetail',
                    // TODO: Not sure if amount is per unit or total
                    'Amount' => $salesTax,

                ])->toArray();
            }

            $qboBill = QboCreateBillData::from([
                'DocNumber' => $accountingTransaction->link->supplier_invoice_number,
                'LinkedTxn' => $linkedPurchaseOrders,
                'VendorRef' => [
                    'value' => $this->vendors->getQboVendorByDisplayName($accountingTransaction->link->supplier->name)->QboId,
                ],
                'CurrencyRef' => [
                    'value' => $accountingTransaction->currency_code,

                ],
                'Line' => $lineItems,
            ]);

            if ($QboId = $accountingTransaction->accountingIntegration?->QboId) {
                $qboBill->Id = $QboId;
                $qboBill->SyncToken = $accountingTransaction->accountingIntegration->json_object['SyncToken'];
            }

            $bills[] = $qboBill->toArray();
        });

        $params = [
            'records' => $bills,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
