<?php

namespace Modules\Qbo\ApiParameterObjects;

class QboQueryVendorApo extends QboQueryApo
{
    public function __construct(
        public ?string $displayName = null
    ) {
        parent::__construct();
    }

    public function transform(): array
    {
        $params = [
            'startPosition' => $this->startPosition,
            'maxResults' => $this->maxResults,
            'whereClause' => [
                'DisplayName' => $this->displayName,
            ],
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
