<?php

namespace Modules\Qbo\ApiParameterObjects;

class QboQueryPurchaseOrderApo extends QboQueryApo
{
    public function __construct(
        public ?array $ids = null
    ) {
        parent::__construct();
    }

    public function transform(): array
    {
        $params = [
            'startPosition' => $this->startPosition,
            'maxResults' => $this->maxResults,
            'whereClause' => [
                'Id' => $this->ids,
            ],
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
