<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Illuminate\Support\Collection;
use Modules\Qbo\Data\QboDeletePaymentsData;
use Modules\Qbo\Entities\QboPayment;

class QboDeletePaymentsApo implements ApiDataTransformerInterface
{
    public function __construct(
        public Collection $qboPayments
    ) {

    }

    public function transform(): array
    {
        $payments = [];

        $this->qboPayments->each(function (QboPayment $payment) use (&$payments) {
            $payments[] = QboDeletePaymentsData::from([
                'Id' => $payment->QboId,
                'SyncToken' => $payment->json_object['SyncToken'],
            ])->toArray();

        });

        $params = [
            'records' => $payments,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
