<?php

namespace Modules\Qbo\ApiParameterObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;

class QboCreateItemApo implements ApiDataTransformerInterface
{
    public function __construct(
        public string $Name,
        public string $IncomeAccountRef,
        public string $ExpenseAccountRef,
        public ?string $SyncToken = null
    ) {
    }

    public function transform(): array
    {
        $return = [
            'Name' => $this->Name,
            'Sku' => $this->Name,
            'Type' => 'NonInventory',
            'IncomeAccountRef' => [
                'value' => $this->IncomeAccountRef,
            ],
            'ExpenseAccountRef' => [
                'value' => $this->ExpenseAccountRef,
            ],
        ];

        if ($this->SyncToken) {
            $return = array_merge($return, [
                'SyncToken' => $this->SyncToken,
            ]);
        }

        return $return;
    }
}
