<?php

namespace Modules\Ebay\Tests\Feature\Managers;

use App\Models\AccountingTransaction;
use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class EbayIntegrationInstanceManagerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private EbayIntegrationInstance $ebayIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->ebayIntegrationInstance = EbayIntegrationInstance::factory([
            'is_automatic_sync_enabled' => true,
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => false,
            ],
        ])->has(SalesChannel::factory())
            ->create();
    }

    public function test_it_will_change_accounting_transactions_when_sync_sales_order_settings_changed(): void
    {
        $salesChannel = $this->ebayIntegrationInstance->salesChannel;

        $salesOrder = SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => false,
        ]);

        $settings                                            = $this->ebayIntegrationInstance->integration_settings;
        $settings['sync_sales_order_invoices_to_accounting'] = true;
        $this->ebayIntegrationInstance->integration_settings = $settings;
        $this->ebayIntegrationInstance->save();

        app(AccountingTransactionManager::class)->syncAccountingTransactionsSalesOrderIsSyncEnabledStatus($this->ebayIntegrationInstance);

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => true,
        ]);
    }
}