<?php

namespace Modules\Ebay\Tests;

class EbayTestingData
{
    public static function getLegacyProducts(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<GetMyeBaySellingResponse
	xmlns="urn:ebay:apis:eBLBaseComponents">
	<Timestamp>2023-12-16T00:05:03.500Z</Timestamp>
	<Ack>Success</Ack>
	<Version>1271</Version>
	<Build>E1271_CORE_APISELLING_19187371_R1</Build>
	<ActiveList>
		<ItemArray>
			<Item>
				<BuyItNowPrice currencyID="USD">39.95</BuyItNowPrice>
				<ItemID>325866322077</ItemID>
				<ListingDetails>
					<StartTime>2023-10-29T00:44:08.000Z</StartTime>
					<ViewItemURL>https://www.ebay.com/itm/Hayg-Orig-Inline-Fuel-Pump-0-580-464-070-0580464070-New-/325866322077</ViewItemURL>
					<ViewItemURLForNaturalSearch>http://cgi.ebay.com/Hayg-Orig-Inline-Fuel-Pump-0-580-464-070-0580464070-New?item=325866322077&amp;category=33555&amp;cmd=ViewItem</ViewItemURLForNaturalSearch>
				</ListingDetails>
				<ListingDuration>GTC</ListingDuration>
				<ListingType>FixedPriceItem</ListingType>
				<Quantity>7</Quantity>
				<SellingStatus>
					<CurrentPrice currencyID="USD">39.95</CurrentPrice>
					<QuantitySold>1</QuantitySold>
				</SellingStatus>
				<ShippingDetails>
					<ShippingServiceOptions>
						<ShippingServiceCost currencyID="USD">0.0</ShippingServiceCost>
					</ShippingServiceOptions>
					<ShippingType>Flat</ShippingType>
				</ShippingDetails>
				<TimeLeft>P13DT1H39M5S</TimeLeft>
				<Title>Hayg Orig Inline Fuel Pump 0 580 464 070 0580464070 New</Title>
				<QuantityAvailable>6</QuantityAvailable>
				<SKU>ORD_SZ070</SKU>
				<ClassifiedAdPayPerLeadFee currencyID="USD">0.0</ClassifiedAdPayPerLeadFee>
				<SellerProfiles>
					<SellerShippingProfile>
						<ShippingProfileID>291706563021</ShippingProfileID>
						<ShippingProfileName>Flat: USPSPriority free, 1 business day (291706563021)</ShippingProfileName>
					</SellerShippingProfile>
					<SellerReturnProfile>
						<ReturnProfileID>281812785021</ReturnProfileID>
						<ReturnProfileName>30 days money back or replacement 43ec81fe8e5a000</ReturnProfileName>
					</SellerReturnProfile>
					<SellerPaymentProfile>
						<PaymentProfileID>279805643021</PaymentProfileID>
						<PaymentProfileName>eBay Managed Payments 407b3406f4c3000</PaymentProfileName>
					</SellerPaymentProfile>
				</SellerProfiles>
			</Item>
			<Item>
				<BuyItNowPrice currencyID="USD">49.95</BuyItNowPrice>
				<ItemID>225841415586</ItemID>
				<ListingDetails>
					<StartTime>2023-10-29T00:43:21.000Z</StartTime>
					<ViewItemURL>https://www.ebay.com/itm/82-94-ALFA-ROMEO-SPIDER-Fuel-Pump-Orig-New-Hayg-Walbro-/225841415586</ViewItemURL>
					<ViewItemURLForNaturalSearch>http://cgi.ebay.com/82-94-ALFA-ROMEO-SPIDER-Fuel-Pump-Orig-New-Hayg-Walbro?item=225841415586&amp;category=33555&amp;cmd=ViewItem</ViewItemURLForNaturalSearch>
				</ListingDetails>
				<ListingDuration>GTC</ListingDuration>
				<ListingType>FixedPriceItem</ListingType>
				<Quantity>7</Quantity>
				<SellingStatus>
					<CurrentPrice currencyID="USD">49.95</CurrentPrice>
					<QuantitySold>1</QuantitySold>
				</SellingStatus>
				<ShippingDetails>
					<ShippingServiceOptions>
						<ShippingServiceCost currencyID="USD">0.0</ShippingServiceCost>
					</ShippingServiceOptions>
					<ShippingType>Flat</ShippingType>
				</ShippingDetails>
				<TimeLeft>P13DT1H38M18S</TimeLeft>
				<Title>82-94 ALFA ROMEO SPIDER Fuel Pump Orig New Hayg Walbro</Title>
				<QuantityAvailable>6</QuantityAvailable>
				<SKU>ORD_SZ071</SKU>
				<ClassifiedAdPayPerLeadFee currencyID="USD">0.0</ClassifiedAdPayPerLeadFee>
				<SellerProfiles>
					<SellerShippingProfile>
						<ShippingProfileID>103871747021</ShippingProfileID>
						<ShippingProfileName>Stock</ShippingProfileName>
					</SellerShippingProfile>
					<SellerReturnProfile>
						<ReturnProfileID>281812785021</ReturnProfileID>
						<ReturnProfileName>30 days money back or replacement 43ec81fe8e5a000</ReturnProfileName>
					</SellerReturnProfile>
					<SellerPaymentProfile>
						<PaymentProfileID>279805643021</PaymentProfileID>
						<PaymentProfileName>eBay Managed Payments 407b3406f4c3000</PaymentProfileName>
					</SellerPaymentProfile>
				</SellerProfiles>
			</Item>			
		</ItemArray>
		<PaginationResult>
			<TotalNumberOfPages>1</TotalNumberOfPages>
			<TotalNumberOfEntries>2</TotalNumberOfEntries>
		</PaginationResult>
	</ActiveList>
	<Summary>
		<ActiveAuctionCount>0</ActiveAuctionCount>
		<AuctionSellingCount>0</AuctionSellingCount>
		<AuctionBidCount>0</AuctionBidCount>
		<TotalAuctionSellingValue currencyID="USD">0.0</TotalAuctionSellingValue>
		<TotalSoldCount>37</TotalSoldCount>
		<TotalSoldValue currencyID="USD">2412.32</TotalSoldValue>
		<SoldDurationInDays>31</SoldDurationInDays>
		<ClassifiedAdCount>0</ClassifiedAdCount>
		<TotalLeadCount>0</TotalLeadCount>
		<ClassifiedAdOfferCount>0</ClassifiedAdOfferCount>
		<TotalListingsWithLeads>0</TotalListingsWithLeads>
		<QuantityLimitRemaining>7199472</QuantityLimitRemaining>
		<AmountLimitRemaining currencyID="USD">6.9996509553E8</AmountLimitRemaining>
	</Summary>
</GetMyeBaySellingResponse>';
    }

    public static function getLegacyReviseInventoryStatusResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<ReviseInventoryStatusResponse
	xmlns="urn:ebay:apis:eBLBaseComponents">
	<Timestamp>2023-12-16T00:05:03.500Z</Timestamp>
	<Ack>Success</Ack>
	<Version>1271</Version>
	<Build>E1271_CORE_APISELLING_19187371_R1</Build>
	<InventoryStatus>
        <ItemID>325866322077</ItemID>
        <SKU>ORD_SZ070</SKU>
	</InventoryStatus>
</ReviseInventoryStatusResponse>';
    }

    public static function getAddItemResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<AddItemResponse xmlns="urn:ebay:apis:eBLBaseComponents">
    <Timestamp>2024-06-14T23:11:46.797Z</Timestamp>
    <Ack>Success</Ack>
    <Version>1365</Version>
    <Build>E1365_UNI_API5_19110891_R1</Build>
    <ItemID>355793538336</ItemID>
    <StartTime>2024-06-14T23:11:45.001Z</StartTime>
    <EndTime>2024-06-21T23:11:45.001Z</EndTime>
    <Fees>
        <Fee>
            <Name>AuctionLengthFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BoldFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BuyItNowFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>CategoryFeaturedFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FeaturedFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GalleryPlusFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FeaturedGalleryFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FixedPriceDurationFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GalleryFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GiftIconFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>HighLightFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>InsertionFee</Name>
            <Fee currencyID="USD">0.1</Fee>
        </Fee>
        <Fee>
            <Name>InternationalInsertionFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ListingDesignerFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ListingFee</Name>
            <Fee currencyID="USD">0.1</Fee>
        </Fee>
        <Fee>
            <Name>PhotoDisplayFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>PhotoFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ReserveFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>SchedulingFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>SubtitleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BorderFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ProPackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BasicUpgradePackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ValuePackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>PrivateListingFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ProPackPlusBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>MotorsGermanySearchFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
    </Fees>
    <DiscountReason>SpecialOffer</DiscountReason>
</AddItemResponse>';
    }

    public static function getRelistItemResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<RelistItemResponse xmlns="urn:ebay:apis:eBLBaseComponents">
    <Timestamp>2024-06-21T17:11:08.343Z</Timestamp>
    <Ack>Success</Ack>
    <Version>1365</Version>
    <Build>E1365_UNI_API5_19110891_R1</Build>
    <ItemID>355793538336</ItemID>
    <Fees>
        <Fee>
            <Name>AuctionLengthFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BoldFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BuyItNowFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>CategoryFeaturedFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FeaturedFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GalleryPlusFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FeaturedGalleryFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>FixedPriceDurationFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GalleryFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>GiftIconFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>HighLightFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>InsertionFee</Name>
            <Fee currencyID="USD">0.1</Fee>
        </Fee>
        <Fee>
            <Name>InternationalInsertionFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ListingDesignerFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ListingFee</Name>
            <Fee currencyID="USD">0.1</Fee>
        </Fee>
        <Fee>
            <Name>PhotoDisplayFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>PhotoFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ReserveFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>SchedulingFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>SubtitleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BorderFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ProPackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>BasicUpgradePackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ValuePackBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>PrivateListingFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>ProPackPlusBundleFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
        <Fee>
            <Name>MotorsGermanySearchFee</Name>
            <Fee currencyID="USD">0.0</Fee>
        </Fee>
    </Fees>
    <StartTime>2024-06-21T17:11:06.598Z</StartTime>
    <EndTime>2024-06-28T17:11:06.598Z</EndTime>
    <DiscountReason>SpecialOffer</DiscountReason>
</RelistItemResponse>';
    }

    public static function getUploadSiteHostedPictureResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<UploadSiteHostedPicturesResponse xmlns="urn:ebay:apis:eBLBaseComponents">
    <Timestamp>2024-06-14T23:11:46.797Z</Timestamp>
    <Ack>Success</Ack>
    <Version>1365</Version>
    <Build>E1365_UNI_API5_19110891_R1</Build>
    <SiteHostedPictureDetails>
        <BaseURL>https://i.ebayimg.com/images/g/1~AAAOSw8b9gJ9Zz/</BaseURL>
        <ExternalPictureURL>https://images.google.com/s-l1600.jpg</ExternalPictureURL>
        <FullURL>https://i.ebayimg.com/images/g/1~AAAOSw8b9gJ9Zz/s-l1600.jpg</FullURL>
        <PictureFormat>JPEG</PictureFormat>
        <PictureName>https://i.ebayimg.com/images/g/1~AAAOSw8b9gJ9Zz/s-l1600.jpg</PictureName>
        <PictureSet>Standard</PictureSet>
        <PictureSetMember>
            <MemberURL>https://i.ebayimg.com/images/g/1~AAAOSw8b9gJ9Zz/s-l1600.jpg</MemberURL>
            <PictureHeight>1600</PictureHeight>
            <PictureWidth>1600</PictureWidth>
        </PictureSetMember>
        <UseByDate>2024-06-21T23:11:46.797Z</UseByDate>
    </SiteHostedPictureDetails>
</UploadSiteHostedPicturesResponse>';
    }

    public static function getGetItemResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<GetItemResponse xmlns="urn:ebay:apis:eBLBaseComponents">
    <Timestamp>2024-06-14T23:11:59.894Z</Timestamp>
    <Ack>Success</Ack>
    <Version>1193</Version>
    <Build>E1193_CORE_API_19146280_R1</Build>
    <Item>
        <ApplicationData>SKUsku</ApplicationData>
        <AutoPay>true</AutoPay>
        <BuyerProtection>ItemIneligible</BuyerProtection>
        <BuyItNowPrice currencyID="USD">1000.0</BuyItNowPrice>
        <Country>US</Country>
        <Currency>USD</Currency>
        <ItemID>355793538336</ItemID>
        <ListingDetails>
            <Adult>false</Adult>
            <BindingAuction>false</BindingAuction>
            <CheckoutEnabled>true</CheckoutEnabled>
            <ConvertedBuyItNowPrice currencyID="USD">1000.0</ConvertedBuyItNowPrice>
            <ConvertedStartPrice currencyID="USD">500.05</ConvertedStartPrice>
            <ConvertedReservePrice currencyID="USD">0.0</ConvertedReservePrice>
            <HasReservePrice>false</HasReservePrice>
            <StartTime>2024-06-14T23:11:45.000Z</StartTime>
            <EndTime>2024-06-21T23:11:45.000Z</EndTime>
            <ViewItemURL>https://www.ebay.com/itm/iCarsoft-MB-V3-0-Mercedes-Benz-Sprinter-Smart-Diagnostic-Tool-/355793538336</ViewItemURL>
            <HasUnansweredQuestions>false</HasUnansweredQuestions>
            <HasPublicMessages>false</HasPublicMessages>
            <BuyItNowAvailable>true</BuyItNowAvailable>
            <ViewItemURLForNaturalSearch>https://www.ebay.com/itm/iCarsoft-MB-V3-0-Mercedes-Benz-Sprinter-Smart-Diagnostic-Tool-/355793538336</ViewItemURLForNaturalSearch>
        </ListingDetails>
        <ListingDuration>Days_7</ListingDuration>
        <ListingType>Chinese</ListingType>
        <Location>North Las Vegas, Nevada</Location>
        <PrimaryCategory>
            <CategoryID>179476</CategoryID>
            <CategoryName>eBay Motors:Automotive Tools &amp; Supplies:Diagnostic Service Tools:Code Readers &amp; Scanners</CategoryName>
        </PrimaryCategory>
        <PrivateListing>false</PrivateListing>
        <Quantity>1</Quantity>
        <IsItemEMSEligible>false</IsItemEMSEligible>
        <ReservePrice currencyID="USD">0.0</ReservePrice>
        <ReviseStatus>
            <ItemRevised>false</ItemRevised>
        </ReviseStatus>
        <Seller>
            <AboutMePage>false</AboutMePage>
            <Email>sales@partusa.com</Email>
            <FeedbackScore>8548</FeedbackScore>
            <PositiveFeedbackPercent>99.4</PositiveFeedbackPercent>
            <FeedbackPrivate>false</FeedbackPrivate>
            <IDVerified>false</IDVerified>
            <eBayGoodStanding>true</eBayGoodStanding>
            <NewUser>false</NewUser>
            <RegistrationDate>2010-02-11T04:21:29.000Z</RegistrationDate>
            <Site>US</Site>
            <Status>Confirmed</Status>
            <UserID>partusa-outlet</UserID>
            <UserIDChanged>false</UserIDChanged>
            <UserIDLastChanged>2016-09-25T07:30:36.000Z</UserIDLastChanged>
            <VATStatus>NoVATTax</VATStatus>
            <SellerInfo>
                <AllowPaymentEdit>true</AllowPaymentEdit>
                <CheckoutEnabled>true</CheckoutEnabled>
                <CIPBankAccountStored>false</CIPBankAccountStored>
                <GoodStanding>true</GoodStanding>
                <LiveAuctionAuthorized>false</LiveAuctionAuthorized>
                <MerchandizingPref>OptIn</MerchandizingPref>
                <QualifiesForB2BVAT>false</QualifiesForB2BVAT>
                <StoreOwner>true</StoreOwner>
                <StoreURL>https://www.ebay.com/str/partusaoutlet</StoreURL>
                <SafePaymentExempt>false</SafePaymentExempt>
            </SellerInfo>
            <MotorsDealer>false</MotorsDealer>
        </Seller>
        <SellingStatus>
            <BidCount>0</BidCount>
            <BidIncrement currencyID="USD">10.0</BidIncrement>
            <ConvertedCurrentPrice currencyID="USD">500.05</ConvertedCurrentPrice>
            <CurrentPrice currencyID="USD">500.05</CurrentPrice>
            <LeadCount>0</LeadCount>
            <MinimumToBid currencyID="USD">500.05</MinimumToBid>
            <QuantitySold>0</QuantitySold>
            <ReserveMet>true</ReserveMet>
            <SecondChanceEligible>false</SecondChanceEligible>
            <ListingStatus>Active</ListingStatus>
            <QuantitySoldByPickupInStore>0</QuantitySoldByPickupInStore>
        </SellingStatus>
        <ShippingDetails>
            <ApplyShippingDiscount>false</ApplyShippingDiscount>
            <CalculatedShippingRate>
                <WeightMajor measurementSystem="English" unit="lbs">0</WeightMajor>
                <WeightMinor measurementSystem="English" unit="oz">0</WeightMinor>
            </CalculatedShippingRate>
            <SalesTax>
                <SalesTaxPercent>0.0</SalesTaxPercent>
                <ShippingIncludedInTax>false</ShippingIncludedInTax>
            </SalesTax>
            <ShippingServiceOptions>
                <ShippingService>USPSPriority</ShippingService>
                <ShippingServiceCost currencyID="USD">0.0</ShippingServiceCost>
                <ShippingServicePriority>1</ShippingServicePriority>
                <ExpeditedService>false</ExpeditedService>
                <ShippingTimeMin>1</ShippingTimeMin>
                <ShippingTimeMax>4</ShippingTimeMax>
                <FreeShipping>true</FreeShipping>
            </ShippingServiceOptions>
            <ShippingServiceOptions>
                <ShippingService>USPSExpressMail</ShippingService>
                <ShippingServiceCost currencyID="USD">20.0</ShippingServiceCost>
                <ShippingServicePriority>2</ShippingServicePriority>
                <ExpeditedService>false</ExpeditedService>
                <ShippingTimeMin>1</ShippingTimeMin>
                <ShippingTimeMax>2</ShippingTimeMax>
            </ShippingServiceOptions>
            <ShippingType>Flat</ShippingType>
            <ThirdPartyCheckout>false</ThirdPartyCheckout>
            <ShippingDiscountProfileID>0</ShippingDiscountProfileID>
            <InternationalShippingDiscountProfileID>0</InternationalShippingDiscountProfileID>
            <SellerExcludeShipToLocationsPreference>true</SellerExcludeShipToLocationsPreference>
        </ShippingDetails>
        <ShipToLocations>US</ShipToLocations>
        <Site>eBayMotors</Site>
        <StartPrice currencyID="USD">500.05</StartPrice>
        <Storefront>
            <StoreCategoryID>1</StoreCategoryID>
            <StoreCategory2ID>0</StoreCategory2ID>
            <StoreURL>https://www.ebay.com/str/partusaoutlet</StoreURL>
        </Storefront>
        <TimeLeft>P6DT23H59M46S</TimeLeft>
        <Title>iCarsoft MB V3.0 for Mercedes-Benz/Sprinter/Smart Diagnostic Tool</Title>
        <BuyerResponsibleForShipping>false</BuyerResponsibleForShipping>
        <SKU>testMBV3.0</SKU>
        <DispatchTimeMax>3</DispatchTimeMax>
        <ProxyItem>false</ProxyItem>
        <BuyerGuaranteePrice currencyID="USD">20000.0</BuyerGuaranteePrice>
        <IntangibleItem>false</IntangibleItem>
        <ReturnPolicy>
            <ReturnsWithinOption>Days_30</ReturnsWithinOption>
            <ReturnsWithin>30 Days</ReturnsWithin>
            <ReturnsAcceptedOption>ReturnsAccepted</ReturnsAcceptedOption>
            <ReturnsAccepted>Returns Accepted</ReturnsAccepted>
            <ShippingCostPaidByOption>Buyer</ShippingCostPaidByOption>
            <ShippingCostPaidBy>Buyer</ShippingCostPaidBy>
        </ReturnPolicy>
        <ConditionID>1500</ConditionID>
        <ConditionDescription>Return in good condition</ConditionDescription>
        <ConditionDisplayName>New other (see details)</ConditionDisplayName>
        <PostCheckoutExperienceEnabled>false</PostCheckoutExperienceEnabled>
        <SellerProfiles>
            <SellerShippingProfile>
                <ShippingProfileID>106650230013</ShippingProfileID>
                <ShippingProfileName>Stock</ShippingProfileName>
            </SellerShippingProfile>
            <SellerReturnProfile>
                <ReturnProfileID>221479597013</ReturnProfileID>
                <ReturnProfileName>Returns Accepted,Buyer,30 Days,Money Back</ReturnProfileName>
            </SellerReturnProfile>
            <SellerPaymentProfile>
                <PaymentProfileID>221479599013</PaymentProfileID>
                <PaymentProfileName>eBay Payments:Immediate pay</PaymentProfileName>
            </SellerPaymentProfile>
        </SellerProfiles>
        <ShippingPackageDetails>
            <ShippingIrregular>false</ShippingIrregular>
            <ShippingPackage>None</ShippingPackage>
            <WeightMajor measurementSystem="English" unit="lbs">0</WeightMajor>
            <WeightMinor measurementSystem="English" unit="oz">0</WeightMinor>
        </ShippingPackageDetails>
        <HideFromSearch>false</HideFromSearch>
        <OutOfStockControl>true</OutOfStockControl>
        <eBayPlus>false</eBayPlus>
        <eBayPlusEligible>false</eBayPlusEligible>
        <IsSecureDescription>false</IsSecureDescription>
    </Item>
</GetItemResponse>';
    }

    public static function getSuggestedCategoriesResponse(): string
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<GetSuggestedCategoriesResponse xmlns="urn:ebay:apis:eBLBaseComponents">
    <Timestamp>2024-06-17T19:11:26.614Z</Timestamp>
    <Ack>Success</Ack>
    <Version>1337</Version>
    <Build>E1337_CORE_API5_19110890_R1</Build>
    <SuggestedCategoryArray>
        <SuggestedCategory>
            <Category>
                <CategoryID>179476</CategoryID>
                <CategoryName>Code Readers &amp; Scanners</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentID>179474</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
                <CategoryParentName>Diagnostic Service Tools</CategoryParentName>
            </Category>
            <PercentItemFound>98</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>155707</CategoryID>
                <CategoryName>Cables &amp; Adapters</CategoryName>
                <CategoryParentID>625</CategoryParentID>
                <CategoryParentID>15200</CategoryParentID>
                <CategoryParentName>Cameras &amp; Photo</CategoryParentName>
                <CategoryParentName>Camera, Drone &amp; Photo Accessories</CategoryParentName>
            </Category>
            <PercentItemFound>1</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>179486</CategoryID>
                <CategoryName>Other Diagnostic Service Tools</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentID>179474</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
                <CategoryParentName>Diagnostic Service Tools</CategoryParentName>
            </Category>
            <PercentItemFound>1</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>1498</CategoryID>
                <CategoryName>Other Vehicle Electronics</CategoryName>
                <CategoryParentID>293</CategoryParentID>
                <CategoryParentID>3270</CategoryParentID>
                <CategoryParentName>Consumer Electronics</CategoryParentName>
                <CategoryParentName>Vehicle Electronics &amp; GPS</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>33654</CategoryID>
                <CategoryName>Body Moldings &amp; Trims</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>6028</CategoryParentID>
                <CategoryParentID>6030</CategoryParentID>
                <CategoryParentID>33637</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Parts &amp; Accessories</CategoryParentName>
                <CategoryParentName>Car &amp; Truck Parts &amp; Accessories</CategoryParentName>
                <CategoryParentName>Exterior Parts &amp; Accessories</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>35625</CategoryID>
                <CategoryName>Other Automotive Hand Tools</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentID>43990</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
                <CategoryParentName>Hand Tools</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>179484</CategoryID>
                <CategoryName>Diagnostic Software</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentID>179474</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
                <CategoryParentName>Diagnostic Service Tools</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>180040</CategoryID>
                <CategoryName>Connectors, Adapters &amp; Parts</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentID>179474</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
                <CategoryParentName>Diagnostic Service Tools</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
        <SuggestedCategory>
            <Category>
                <CategoryID>43998</CategoryID>
                <CategoryName>Other Auto Tools &amp; Supplies</CategoryName>
                <CategoryParentID>6000</CategoryParentID>
                <CategoryParentID>34998</CategoryParentID>
                <CategoryParentName>eBay Motors</CategoryParentName>
                <CategoryParentName>Automotive Tools &amp; Supplies</CategoryParentName>
            </Category>
            <PercentItemFound>0</PercentItemFound>
        </SuggestedCategory>
    </SuggestedCategoryArray>
    <CategoryCount>9</CategoryCount>
</GetSuggestedCategoriesResponse>';
    }

    public static function getOrders(): array
    {
        return [
            'orders' => [
                [
                    "orderId" => "03-10935-20279",
                    "legacyOrderId" => "03-10935-20279",
                    "creationDate" => "2023-12-14T16:14:56.000Z",
                    "lastModifiedDate" => "2023-12-15T11:47:18.000Z",
                    "orderFulfillmentStatus" => "FULFILLED",
                    "orderPaymentStatus" => "PAID",
                    "sellerId" => "fuelpumpsusa",
                    "buyer" => [
                        "username" => "n_hysner",
                        "taxAddress" => [
                            "city" => "Hendersonville",
                            "stateOrProvince" => "TN",
                            "postalCode" => "37075-2102",
                            "countryCode" => "US",
                        ],
                        "buyerRegistrationAddress" => [
                            "fullName" => "Nick Hysner",
                            "contactAddress" => [
                                "addressLine1" => "1060 Kennesaw Blvd.",
                                "city" => "Gallatin",
                                "stateOrProvince" => "TN",
                                "postalCode" => "37066",
                                "countryCode" => "US",
                            ],
                            "primaryPhone" => ["phoneNumber" => "6157884343"],
                            "email" => "nah02nick@gmail.com",
                        ],
                    ],
                    "pricingSummary" => [
                        "priceSubtotal" => ["value" => "74.99", "currency" => "USD"],
                        "deliveryCost" => ["value" => "5.0", "currency" => "USD"],
                        "total" => ["value" => "74.99", "currency" => "USD"],
                    ],
                    "cancelStatus" => [
                        "cancelState" => "NONE_REQUESTED",
                        "cancelRequests" => [],
                    ],
                    "paymentSummary" => [
                        "totalDueSeller" => ["value" => "60.47", "currency" => "USD"],
                        "refunds" => [],
                        "payments" => [
                            [
                                "paymentMethod" => "EBAY",
                                "paymentReferenceId" => "420004_S",
                                "paymentDate" => "2023-12-14T16:14:55.765Z",
                                "amount" => ["value" => "60.47", "currency" => "USD"],
                                "paymentStatus" => "PAID",
                            ],
                        ],
                    ],
                    "fulfillmentStartInstructions" => [
                        [
                            "fulfillmentInstructionsType" => "SHIP_TO",
                            "minEstimatedDeliveryDate" => "2023-12-18T13:00:00.000Z",
                            "maxEstimatedDeliveryDate" => "2023-12-18T13:00:00.000Z",
                            "ebaySupportedFulfillment" => false,
                            "shippingStep" => [
                                "shipTo" => [
                                    "fullName" => "Nick Hysner",
                                    "contactAddress" => [
                                        "addressLine1" => "102 Cedar Valley Rd",
                                        "city" => "Hendersonville",
                                        "stateOrProvince" => "TN",
                                        "postalCode" => "37075-2102",
                                        "countryCode" => "US",
                                    ],
                                    "primaryPhone" => ["phoneNumber" => "6157884343"],
                                    "email" => "nah02nick@gmail.com",
                                ],
                                "shippingCarrierCode" => "USPS",
                                "shippingServiceCode" => "USPSPriority",
                            ],
                        ],
                    ],
                    "fulfillmentHrefs" => [
                        "https://api.ebay.com/sell/fulfillment/v1/order/03-10935-20279/shipping_fulfillment/9405511206210810266122",
                    ],
                    "lineItems" => [
                        [
                            "lineItemId" => "10060367161503",
                            "legacyItemId" => "224063402113",
                            "sku" => "ORD_GSS342+400-791",
                            "title" =>
                                "Walbro GSS342 Fuel Pump + 400-791 Installation Kit, 255 LPH and 500HP",
                            "lineItemCost" => ["value" => "74.99", "currency" => "USD"],
                            "quantity" => 1,
                            "soldFormat" => "FIXED_PRICE",
                            "listingMarketplaceId" => "EBAY_MOTORS_US",
                            "purchaseMarketplaceId" => "EBAY_US",
                            "lineItemFulfillmentStatus" => "FULFILLED",
                            "total" => ["value" => "74.99", "currency" => "USD"],
                            "deliveryCost" => [
                                "shippingCost" => ["value" => "0.0", "currency" => "USD"],
                            ],
                            "appliedPromotions" => [],
                            "taxes" => [],
                            "ebayCollectAndRemitTaxes" => [
                                [
                                    "taxType" => "STATE_SALES_TAX",
                                    "amount" => ["value" => "6.94", "currency" => "USD"],
                                    "collectionMethod" => "NET",
                                ],
                            ],
                            "properties" => ["buyerProtection" => true],
                            "lineItemFulfillmentInstructions" => [
                                "minEstimatedDeliveryDate" => "2023-12-18T13:00:00.000Z",
                                "maxEstimatedDeliveryDate" => "2023-12-18T13:00:00.000Z",
                                "shipByDate" => "2023-12-16T07:59:59.000Z",
                                "guaranteedDelivery" => false,
                            ],
                            "itemLocation" => [
                                "location" => "North Las Vegas, Nevada",
                                "countryCode" => "US",
                                "postalCode" => "89030",
                            ],
                        ],
                    ],
                    "ebayCollectAndRemitTax" => true,
                    "salesRecordReference" => "36600",
                    "totalFeeBasisAmount" => ["value" => "81.93", "currency" => "USD"],
                    "totalMarketplaceFee" => ["value" => "14.52", "currency" => "USD"],
                    "creationDateUtc" => "2023-12-14 16:14:56",
                    "lastModifiedDateUtc" => "2023-12-15 11:47:18",
                ],
                [
                    "orderId" => "18-10915-28177",
                    "legacyOrderId" => "18-10915-28177",
                    "creationDate" => "2023-12-12T16:20:19.000Z",
                    "lastModifiedDate" => "2023-12-15T17:56:01.000Z",
                    "orderFulfillmentStatus" => "FULFILLED",
                    "orderPaymentStatus" => "PAID",
                    "sellerId" => "fuelpumpsusa",
                    "buyer" => [
                        "username" => "2014-alzia",
                        "taxAddress" => [
                            "city" => "franklin lakes",
                            "stateOrProvince" => "NJ",
                            "postalCode" => "07417-1344",
                            "countryCode" => "US",
                        ],
                        "buyerRegistrationAddress" => [
                            "fullName" => "bassam alziatawi",
                            "contactAddress" => [
                                "addressLine1" => "1 kinderkamack rd apt 9",
                                "city" => "Oradell",
                                "stateOrProvince" => "NJ",
                                "postalCode" => "07649",
                                "countryCode" => "US",
                            ],
                            "primaryPhone" => ["phoneNumber" => "2018888642"],
                            "email" => "zitawi@hotmail.com",
                        ],
                    ],
                    "pricingSummary" => [
                        "priceSubtotal" => ["value" => "49.95", "currency" => "USD"],
                        "deliveryCost" => ["value" => "0.0", "currency" => "USD"],
                        "total" => ["value" => "49.95", "currency" => "USD"],
                    ],
                    "cancelStatus" => [
                        "cancelState" => "NONE_REQUESTED",
                        "cancelRequests" => [],
                    ],
                    "paymentSummary" => [
                        "totalDueSeller" => ["value" => "40.4", "currency" => "USD"],
                        "refunds" => [],
                        "payments" => [
                            [
                                "paymentMethod" => "EBAY",
                                "paymentReferenceId" => "420004_S",
                                "paymentDate" => "2023-12-12T16:20:18.608Z",
                                "amount" => ["value" => "40.4", "currency" => "USD"],
                                "paymentStatus" => "PAID",
                            ],
                        ],
                    ],
                    "fulfillmentStartInstructions" => [
                        [
                            "fulfillmentInstructionsType" => "SHIP_TO",
                            "minEstimatedDeliveryDate" => "2023-12-15T13:00:00.000Z",
                            "maxEstimatedDeliveryDate" => "2023-12-15T13:00:00.000Z",
                            "ebaySupportedFulfillment" => false,
                            "shippingStep" => [
                                "shipTo" => [
                                    "fullName" => "Bassam Alziatawi",
                                    "contactAddress" => [
                                        "addressLine1" => "791 franklin ave",
                                        "city" => "franklin lakes",
                                        "stateOrProvince" => "NJ",
                                        "postalCode" => "07417-1344",
                                        "countryCode" => "US",
                                    ],
                                    "primaryPhone" => ["phoneNumber" => "2018888642"],
                                    "email" => "zitawi@hotmail.com",
                                ],
                                "shippingCarrierCode" => "USPS",
                                "shippingServiceCode" => "USPSPriority",
                            ],
                        ],
                    ],
                    "fulfillmentHrefs" => [
                        "https://api.ebay.com/sell/fulfillment/v1/order/18-10915-28177/shipping_fulfillment/9405511206210877240875",
                    ],
                    "lineItems" => [
                        [
                            "lineItemId" => "10062448581518",
                            "legacyItemId" => "225841415586",
                            "sku" => "ORD_SZ070",
                            "title" => "82-94 ALFA ROMEO SPIDER Fuel Pump Orig New Hayg Walbro",
                            "lineItemCost" => ["value" => "49.95", "currency" => "USD"],
                            "quantity" => 1,
                            "soldFormat" => "FIXED_PRICE",
                            "listingMarketplaceId" => "EBAY_MOTORS_US",
                            "purchaseMarketplaceId" => "EBAY_US",
                            "lineItemFulfillmentStatus" => "FULFILLED",
                            "total" => ["value" => "49.95", "currency" => "USD"],
                            "deliveryCost" => [
                                "shippingCost" => ["value" => "0.0", "currency" => "USD"],
                            ],
                            "appliedPromotions" => [],
                            "taxes" => [],
                            "ebayCollectAndRemitTaxes" => [
                                [
                                    "taxType" => "STATE_SALES_TAX",
                                    "amount" => ["value" => "3.31", "currency" => "USD"],
                                    "collectionMethod" => "NET",
                                ],
                            ],
                            "properties" => ["buyerProtection" => true],
                            "lineItemFulfillmentInstructions" => [
                                "minEstimatedDeliveryDate" => "2023-12-15T13:00:00.000Z",
                                "maxEstimatedDeliveryDate" => "2023-12-15T13:00:00.000Z",
                                "shipByDate" => "2023-12-14T07:59:59.000Z",
                                "guaranteedDelivery" => false,
                            ],
                            "itemLocation" => [
                                "location" => "North Las Vegas, Nevada",
                                "countryCode" => "US",
                                "postalCode" => "89030",
                            ],
                        ],
                    ],
                    "ebayCollectAndRemitTax" => true,
                    "salesRecordReference" => "36598",
                    "totalFeeBasisAmount" => ["value" => "53.26", "currency" => "USD"],
                    "totalMarketplaceFee" => ["value" => "9.55", "currency" => "USD"],
                    "creationDateUtc" => "2023-12-12 16:20:19",
                    "lastModifiedDateUtc" => "2023-12-15 17:56:01",
                ],
            ],
        ];
    }

    public static function getRefreshTokenFromAuthCode(): array
    {
        return [
            'refresh_token' => 'refresh token',
            'access_token' => 'access token',
        ];
    }

    public static function getAccessToken(): array
    {
        return [
            'access_token' => 'access token',
        ];
    }

    public static function getEbayCanceledOrderStage1(): array
    {
        return [
            "orderId" => "12-11490-46882",
            "legacyOrderId" => "12-11490-46882",
            "creationDate" => "2024-04-26T11:07:20.000Z",
            "lastModifiedDate" => "2024-04-26T11:28:31.000Z",
            "orderFulfillmentStatus" => "NOT_STARTED",
            "orderPaymentStatus" => "PAID",
            "sellerId" => "verticallambodoors",
            "buyer" => [
                "username" => "vitalijuskukauska0",
                "taxAddress" => ["postalCode" => "TW13 4EH", "countryCode" => "GB"],
                "buyerRegistrationAddress" => [
                    "fullName" => "Vitalijus Skukauskas",
                    "contactAddress" => [
                        "addressLine1" => "133 Rochester Avenue",
                        "city" => "FELTHAM",
                        "stateOrProvince" => "London",
                        "postalCode" => "TW134EH",
                        "countryCode" => "GB",
                    ],
                    "primaryPhone" => ["phoneNumber" => "7708070713"],
                    "email" => "vitalijus.s1977@gmail.com",
                ],
            ],
            "buyerCheckoutNotes" => "Item ID: 170468028584
Buyer\'s Vehicle: 2011 Chevrolet Camaro LT Convertible 2-Door 3.6L 3564CC 217Cu. In. V6 GAS DOHC Naturally Aspirated
",
            "pricingSummary" => [
                "priceSubtotal" => ["value" => "1000.0", "currency" => "USD"],
                "deliveryCost" => ["value" => "0.0", "currency" => "USD"],
                "total" => ["value" => "1000.0", "currency" => "USD"],
            ],
            "cancelStatus" => ["cancelState" => "IN_PROGRESS", "cancelRequests" => []],
            "paymentSummary" => [
                "totalDueSeller" => ["value" => "869.6", "currency" => "USD"],
                "refunds" => [],
                "payments" => [
                    [
                        "paymentMethod" => "EBAY",
                        "paymentReferenceId" => "420004_S",
                        "paymentDate" => "2024-04-26T11:07:19.656Z",
                        "amount" => ["value" => "869.6", "currency" => "USD"],
                        "paymentStatus" => "PAID",
                    ],
                ],
            ],
            "fulfillmentStartInstructions" => [
                [
                    "fulfillmentInstructionsType" => "SHIP_TO",
                    "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                    "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                    "ebaySupportedFulfillment" => false,
                    "shippingStep" => [
                        "shipTo" => [
                            "fullName" => "Vitalijus  Skukauskas",
                            "contactAddress" => [
                                "addressLine1" => "133 Rochester Avenue",
                                "city" => "Feltham",
                                "postalCode" => "TW13 4EH",
                                "countryCode" => "GB",
                            ],
                            "primaryPhone" => ["phoneNumber" => "07708070713"],
                            "email" => "vitalijus.s1977@gmail.com",
                        ],
                        "shippingCarrierCode" => "USPS",
                        "shippingServiceCode" => "USPSExpressMailInternational",
                    ],
                ],
            ],
            "fulfillmentHrefs" => [],
            "lineItems" => [
                [
                    "lineItemId" => "10062795588612",
                    "legacyItemId" => "170468028584",
                    "sku" => "ORD_VDCCHEVYCAM10",
                    "title" =>
                        "Chevy Camaro 2010-2015 Lambo Kit Vertical Doors Inc 10 New",
                    "lineItemCost" => ["value" => "1000.0", "currency" => "USD"],
                    "quantity" => 1,
                    "soldFormat" => "FIXED_PRICE",
                    "listingMarketplaceId" => "EBAY_MOTORS_US",
                    "purchaseMarketplaceId" => "EBAY_GB",
                    "lineItemFulfillmentStatus" => "NOT_STARTED",
                    "total" => ["value" => "1000.0", "currency" => "USD"],
                    "deliveryCost" => [
                        "shippingCost" => ["value" => "0.0", "currency" => "USD"],
                    ],
                    "appliedPromotions" => [],
                    "taxes" => [],
                    "properties" => ["buyerProtection" => true],
                    "lineItemFulfillmentInstructions" => [
                        "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                        "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                        "shipByDate" => "2024-05-25T06:59:59.000Z",
                        "guaranteedDelivery" => false,
                    ],
                    "itemLocation" => [
                        "location" => "Corona, California",
                        "countryCode" => "US",
                        "postalCode" => "92879",
                    ],
                ],
            ],
            "salesRecordReference" => "397",
            "totalFeeBasisAmount" => ["value" => "1000.0", "currency" => "USD"],
            "totalMarketplaceFee" => ["value" => "130.4", "currency" => "USD"],
            "creationDateUtc" => "2024-04-26 11:07:20",
            "lastModifiedDateUtc" => "2024-04-26 11:28:31",
        ];
    }

    public static function getEbayCanceledOrderStage2(): array
    {
        return [
            "orderId" => "12-11490-46882",
            "legacyOrderId" => "12-11490-46882",
            "creationDate" => "2024-04-26T11:07:20.000Z",
            "lastModifiedDate" => "2024-04-27T23:57:45.000Z",
            "orderFulfillmentStatus" => "NOT_STARTED",
            "orderPaymentStatus" => "PAID",
            "sellerId" => "verticallambodoors",
            "buyer" => [
                "username" => "vitalijuskukauska0",
                "taxAddress" => ["postalCode" => "TW13 4EH", "countryCode" => "GB"],
                "buyerRegistrationAddress" => [
                    "fullName" => "Vitalijus Skukauskas",
                    "contactAddress" => [
                        "addressLine1" => "133 Rochester Avenue",
                        "city" => "FELTHAM",
                        "stateOrProvince" => "London",
                        "postalCode" => "TW134EH",
                        "countryCode" => "GB",
                    ],
                    "primaryPhone" => ["phoneNumber" => "7708070713"],
                    "email" => "vitalijus.s1977@gmail.com",
                ],
            ],
            "buyerCheckoutNotes" => "Item ID: 170468028584
Buyer\'s Vehicle: 2011 Chevrolet Camaro LT Convertible 2-Door 3.6L 3564CC 217Cu. In. V6 GAS DOHC Naturally Aspirated
",
            "pricingSummary" => [
                "priceSubtotal" => ["value" => "1000.0", "currency" => "USD"],
                "deliveryCost" => ["value" => "0.0", "currency" => "USD"],
                "total" => ["value" => "1000.0", "currency" => "USD"],
            ],
            "cancelStatus" => [
                "cancelState" => "IN_PROGRESS",
                "cancelRequests" => [
                    [
                        "cancelReason" => "FOUND_CHEAPER_PRICE",
                        "cancelRequestedDate" => "2024-04-26T11:21:17.000Z",
                        "cancelInitiator" => "BUYER",
                        "cancelRequestId" => "5361194122",
                        "cancelRequestState" => "REQUESTED",
                    ],
                ],
            ],
            "paymentSummary" => [
                "totalDueSeller" => ["value" => "869.6", "currency" => "USD"],
                "refunds" => [
                    [
                        "amount" => ["value" => "869.6", "currency" => "USD"],
                        "refundStatus" => "PENDING",
                        "refundReferenceId" => "5361194122",
                    ],
                ],
                "payments" => [
                    [
                        "paymentMethod" => "EBAY",
                        "paymentReferenceId" => "420004_S",
                        "paymentDate" => "2024-04-26T11:07:19.656Z",
                        "amount" => ["value" => "869.6", "currency" => "USD"],
                        "paymentStatus" => "PAID",
                    ],
                ],
            ],
            "fulfillmentStartInstructions" => [
                [
                    "fulfillmentInstructionsType" => "SHIP_TO",
                    "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                    "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                    "ebaySupportedFulfillment" => false,
                    "shippingStep" => [
                        "shipTo" => [
                            "fullName" => "Vitalijus  Skukauskas",
                            "contactAddress" => [
                                "addressLine1" => "133 Rochester Avenue",
                                "city" => "Feltham",
                                "postalCode" => "TW13 4EH",
                                "countryCode" => "GB",
                            ],
                            "primaryPhone" => ["phoneNumber" => "07708070713"],
                            "email" => "vitalijus.s1977@gmail.com",
                        ],
                        "shippingCarrierCode" => "USPS",
                        "shippingServiceCode" => "USPSExpressMailInternational",
                    ],
                ],
            ],
            "fulfillmentHrefs" => [],
            "lineItems" => [
                [
                    "lineItemId" => "10062795588612",
                    "legacyItemId" => "170468028584",
                    "sku" => "ORD_VDCCHEVYCAM10",
                    "title" =>
                        "Chevy Camaro 2010-2015 Lambo Kit Vertical Doors Inc 10 New",
                    "lineItemCost" => ["value" => "1000.0", "currency" => "USD"],
                    "quantity" => 1,
                    "soldFormat" => "FIXED_PRICE",
                    "listingMarketplaceId" => "EBAY_MOTORS_US",
                    "purchaseMarketplaceId" => "EBAY_GB",
                    "lineItemFulfillmentStatus" => "NOT_STARTED",
                    "total" => ["value" => "1000.0", "currency" => "USD"],
                    "deliveryCost" => [
                        "shippingCost" => ["value" => "0.0", "currency" => "USD"],
                    ],
                    "appliedPromotions" => [],
                    "taxes" => [],
                    "properties" => ["buyerProtection" => true],
                    "lineItemFulfillmentInstructions" => [
                        "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                        "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                        "shipByDate" => "2024-05-25T06:59:59.000Z",
                        "guaranteedDelivery" => false,
                    ],
                    "itemLocation" => [
                        "location" => "Corona, California",
                        "countryCode" => "US",
                        "postalCode" => "92879",
                    ],
                ],
            ],
            "salesRecordReference" => "397",
            "totalFeeBasisAmount" => ["value" => "1000.0", "currency" => "USD"],
            "totalMarketplaceFee" => ["value" => "130.4", "currency" => "USD"],
            "creationDateUtc" => "2024-04-26 11:07:20",
            "lastModifiedDateUtc" => "2024-04-27 23:57:45",
        ];
    }

    public static function getEbayCanceledOrderStage3(): array
    {
        return [
            "orderId" => "12-11490-46882",
            "legacyOrderId" => "12-11490-46882",
            "creationDate" => "2024-04-26T11:07:20.000Z",
            "lastModifiedDate" => "2024-04-28T00:01:28.000Z",
            "orderFulfillmentStatus" => "NOT_STARTED",
            "orderPaymentStatus" => "FULLY_REFUNDED",
            "sellerId" => "verticallambodoors",
            "buyer" => [
                "username" => "vitalijuskukauska0",
                "taxAddress" => ["postalCode" => "TW13 4EH", "countryCode" => "GB"],
                "buyerRegistrationAddress" => [
                    "fullName" => "Vitalijus Skukauskas",
                    "contactAddress" => [
                        "addressLine1" => "133 Rochester Avenue",
                        "city" => "FELTHAM",
                        "stateOrProvince" => "London",
                        "postalCode" => "TW134EH",
                        "countryCode" => "GB",
                    ],
                    "primaryPhone" => ["phoneNumber" => "7708070713"],
                    "email" => "vitalijus.s1977@gmail.com",
                ],
            ],
            "buyerCheckoutNotes" => "Item ID: 170468028584
Buyer\'s Vehicle: 2011 Chevrolet Camaro LT Convertible 2-Door 3.6L 3564CC 217Cu. In. V6 GAS DOHC Naturally Aspirated
",
            "pricingSummary" => [
                "priceSubtotal" => ["value" => "1000.0", "currency" => "USD"],
                "deliveryCost" => ["value" => "0.0", "currency" => "USD"],
                "total" => ["value" => "1000.0", "currency" => "USD"],
            ],
            "cancelStatus" => [
                "cancelState" => "IN_PROGRESS",
                "cancelRequests" => [
                    [
                        "cancelReason" => "FOUND_CHEAPER_PRICE",
                        "cancelRequestedDate" => "2024-04-26T11:21:17.000Z",
                        "cancelInitiator" => "BUYER",
                        "cancelRequestId" => "5361194122",
                        "cancelRequestState" => "COMPLETED",
                    ],
                ],
            ],
            "paymentSummary" => [
                "totalDueSeller" => ["value" => "0.0", "currency" => "USD"],
                "refunds" => [
                    [
                        "refundDate" => "2024-04-28T00:01:12.000Z",
                        "amount" => ["value" => "869.6", "currency" => "USD"],
                        "refundStatus" => "REFUNDED",
                        "refundReferenceId" => "5361194122",
                    ],
                ],
                "payments" => [
                    [
                        "paymentMethod" => "EBAY",
                        "paymentReferenceId" => "420004_S",
                        "paymentDate" => "2024-04-26T11:07:19.656Z",
                        "amount" => ["value" => "869.6", "currency" => "USD"],
                        "paymentStatus" => "PAID",
                    ],
                ],
            ],
            "fulfillmentStartInstructions" => [
                [
                    "fulfillmentInstructionsType" => "SHIP_TO",
                    "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                    "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                    "ebaySupportedFulfillment" => false,
                    "shippingStep" => [
                        "shipTo" => [
                            "fullName" => "Vitalijus  Skukauskas",
                            "contactAddress" => [
                                "addressLine1" => "133 Rochester Avenue",
                                "city" => "Feltham",
                                "postalCode" => "TW13 4EH",
                                "countryCode" => "GB",
                            ],
                            "primaryPhone" => ["phoneNumber" => "07708070713"],
                            "email" => "vitalijus.s1977@gmail.com",
                        ],
                        "shippingCarrierCode" => "USPS",
                        "shippingServiceCode" => "USPSExpressMailInternational",
                    ],
                ],
            ],
            "fulfillmentHrefs" => [],
            "lineItems" => [
                [
                    "lineItemId" => "10062795588612",
                    "legacyItemId" => "170468028584",
                    "sku" => "ORD_VDCCHEVYCAM10",
                    "title" =>
                        "Chevy Camaro 2010-2015 Lambo Kit Vertical Doors Inc 10 New",
                    "lineItemCost" => ["value" => "1000.0", "currency" => "USD"],
                    "quantity" => 1,
                    "soldFormat" => "FIXED_PRICE",
                    "listingMarketplaceId" => "EBAY_MOTORS_US",
                    "purchaseMarketplaceId" => "EBAY_GB",
                    "lineItemFulfillmentStatus" => "NOT_STARTED",
                    "total" => ["value" => "1000.0", "currency" => "USD"],
                    "deliveryCost" => [
                        "shippingCost" => ["value" => "0.0", "currency" => "USD"],
                    ],
                    "appliedPromotions" => [],
                    "taxes" => [],
                    "properties" => ["buyerProtection" => true],
                    "refunds" => [
                        [
                            "refundDate" => "2024-04-28T00:01:12.000Z",
                            "amount" => ["value" => "1000.0", "currency" => "USD"],
                        ],
                    ],
                    "lineItemFulfillmentInstructions" => [
                        "minEstimatedDeliveryDate" => "2024-06-05T23:00:00.000Z",
                        "maxEstimatedDeliveryDate" => "2024-06-13T23:00:00.000Z",
                        "shipByDate" => "2024-05-25T06:59:59.000Z",
                        "guaranteedDelivery" => false,
                    ],
                    "itemLocation" => [
                        "location" => "Corona, California",
                        "countryCode" => "US",
                        "postalCode" => "92879",
                    ],
                ],
            ],
            "salesRecordReference" => "397",
            "totalFeeBasisAmount" => ["value" => "1000.0", "currency" => "USD"],
            "totalMarketplaceFee" => ["value" => "130.4", "currency" => "USD"],
            "creationDateUtc" => "2024-04-26 11:07:20",
            "lastModifiedDateUtc" => "2024-04-28 00:01:28",
        ];
    }
}
