<?php

declare(strict_types=1);

namespace Modules\Ebay\Services\Transformer;

/**
 * Class XmlResponseTransformer
 */
class XmlResponseTransformer
{
    public static function simplexmlToArray($xml)
    {
        $ar = [];
        foreach ($xml->children() as $k => $v) {
            $child = self::simplexmlToArray($v);
            if (count($child) == 0) {
                $child = (string) $v;
            }
            foreach ($v->attributes() as $ak => $av) {
                if (! is_array($child)) {
                    $child = ['value' => $child];
                }
                $child[$ak] = (string) $av;
            }
            if (! array_key_exists($k, $ar)) {
                $ar[$k] = $child;
            } else {
                if (! is_string($ar[$k]) && isset($ar[$k][0])) {
                    $ar[$k][] = $child;
                } else {
                    $ar[$k] = [$ar[$k]];
                    $ar[$k][] = $child;
                }
            }
        }

        return $ar;
    }
}
