<?php

declare(strict_types=1);

namespace Modules\Ebay\Services;

use Exception;
use RuntimeException;
use SimpleXMLElement;

/**
 * Class EbayXmlParser
 */
class EbayXmlParser
{
    protected string $rawXml;

    protected bool $stripNamespaces;

    public function __construct(string $rawXml, bool $stripNamespaces = false)
    {
        $this->rawXml = $rawXml;
        $this->stripNamespaces = $stripNamespaces;
    }

    public function parseResponseXPaths(array $xPaths): array
    {
        libxml_use_internal_errors(true);
        try {
            if ($this->stripNamespaces === true) {
                $this->rawXml = preg_replace('/xmlns[^=]*="[^"]*"/i', '', $this->rawXml);
            }
            $xml = new SimpleXMLElement($this->rawXml);
            if ($this->stripNamespaces === false) {
                $xml->registerXPathNamespace('ns', 'urn:ebay:apis:eBLBaseComponents');
            }
            $knownErrorXPaths = [];

            $allXPaths = array_merge($knownErrorXPaths, $xPaths);
            $parsed = [];
            foreach ($allXPaths as $xPath) {
                $dataNode = $xml->xpath($xPath);
                if (! empty($dataNode)) {
                    if ($dataNode instanceof SimpleXMLElement || is_array($dataNode)) {
                        $parsed[$xPath] = $dataNode;
                    } else {
                        $parsed[$xPath] = (string) $dataNode[0];
                    }
                } else {
                    $parsed[$xPath] = null;
                }
            }

            return $parsed;
        } catch (Exception $e) {
            throw new RuntimeException(
                message: 'Ebay: not valid XML.',
                previous: $e
            );
        }
    }
}
