<?php

use Illuminate\Support\Facades\Route;
use Modules\Ebay\Entities\EbayLegacyProduct;
use Modules\Ebay\Http\Controllers\EbayAuthenticationController;
use Modules\Ebay\Http\Controllers\EbayComplianceController;
use Modules\Ebay\Http\Controllers\EbayLegacyProductController;
use Modules\Ebay\Http\Controllers\EbayOrderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('export/ebay/{integrationInstance}')->name('ebay.')->group(function () {
    Route::get('/legacy-products', [EbayLegacyProductController::class, 'exportForIntegration'])->name('legacy-products.export-download');
    Route::get('/orders', [EbayOrderController::class, 'exportForIntegration'])->name('orders.export-download');
});

Route::prefix('ebay')->name('ebay.')->group(function () {


    Route::prefix('compliance/marketplace-account-deletion')
        ->name('compliance.')
        ->controller(EbayComplianceController::class)
        ->group(function () {
            Route::get('/', 'marketplaceAccountDeletion')->name('get');
            Route::post('/', 'handleMarketplaceAccountDeletion')->name('post');
        });

    Route::controller(EbayAuthenticationController::class)->group(function () {
        Route::any('callback', 'callback')->name('callback');
        // TODO: Read documentation and write tests
        Route::any('oauth-failed', 'oauthFailed');
    });
});