<?php

namespace Modules\Ebay\Repositories;

use App\Models\Product;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Modules\Ebay\Entities\EbayLegacyProduct;

class EbayGlobalReportRepository
{
    public function getUncoveredBlemishedProducts(): Collection
    {
        return Product::with(['productListings.ebayLegacyProduct', 'productListings.salesChannel.integrationInstance', 'ebayProductSettings.integrationInstance'])
            ->where("type", Product::TYPE_BLEMISHED)
            ->whereHas("productInventory", function (Builder $query) {
                $query->where('warehouse_id', 0);
                $query->where("inventory_available", ">", 0);
            })
            ->whereDoesntHave("productListings", function (Builder $query) {
                $query->where('document_type', EbayLegacyProduct::class);
                $query->whereHas("ebayLegacyProduct", function (Builder $query) {
                    $query->where("ListingType", "Chinese");
                    $query->where("ListingStatus", "Active");
                });
            })
            ->get();
    }

    public function getListedBlemishedProductsOutOfStock(): Collection
    {
        return Product::with(['productListings.ebayLegacyProduct', 'productListings.salesChannel.integrationInstance'])
            ->where("type", Product::TYPE_BLEMISHED)
            ->where(function (Builder $query) {
                $query->whereDoesntHave('productInventory');
                $query->orWhereHas("productInventory", function (Builder $query) {
                    $query->where('warehouse_id', 0);
                    $query->where("inventory_available", "<=", 0);
                });
            })
            ->whereHas("productListings", function (Builder $query) {
                $query->where('document_type', EbayLegacyProduct::class);
                $query->whereHas("ebayLegacyProduct", function (Builder $query) {
                    $query->where("ListingType", "Chinese");
                    $query->where("ListingStatus", "Active");
                });
            })
            ->get();
    }

}