<?php

namespace Modules\Ebay\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Carbon\Carbon;
use Exception;
use Modules\Ebay\ApiDataTransferObjects\EbayGetOrdersAdt;
use Modules\Ebay\Data\EbayResponseData;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayOrder;
use Modules\Ebay\Jobs\Abstractions\EbayJob;
use Modules\Ebay\Managers\EbayOrderManager;
use Modules\Ebay\Repositories\EbayOrderRepository;
use Throwable;

class RefreshEbayOrdersJob extends EbayJob //implements ShouldBeUnique
{
    public string $uniqueId;

    public function __construct(
        protected EbayIntegrationInstance $ebayIntegrationInstance,
        protected EbayGetOrdersAdt $parameters,
    ) {
        $this->uniqueId = get_class($this).':'.$this->ebayIntegrationInstance->id;

        $this->isPageEnabledJob = false;
    }

    /**
     * @return EbayResponseData|ClientResponseDataInterface
     * @throws Throwable
     */
    public function apiCall(): EbayResponseData|ClientResponseDataInterface
    {
        if ($nextEndpoint = @$this->jobPayload['nextEndpoint']) {
            $this->parameters->nextEndpoint = $nextEndpoint;
        }

        // If no records yet, use the created after parameter
        if (EbayOrder::where('integration_instance_id', $this->ebayIntegrationInstance->id)->count() === 0) {
            $this->parameters->created_after = app(EbayOrderRepository::class)->getStartDateForNew($this->ebayIntegrationInstance);
        } elseif (is_null($this->parameters->last_updated_after)) {
            $this->parameters->last_updated_after = app(EbayOrderRepository::class)->getStartDateForNew($this->ebayIntegrationInstance);
        }

        return (new EbayOrderManager($this->ebayIntegrationInstance))->refreshOrders($this->parameters);
    }
}
