<?php

namespace Modules\Ebay\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Ebay\ApiDataTransferObjects\EbayGetLegacyProductsAdt;
use Modules\Ebay\Data\EbayResponseData;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayLegacyProduct;
use Modules\Ebay\Jobs\Abstractions\EbayJob;
use Modules\Ebay\Managers\EbayLegacyProductManager;
use Modules\Ebay\Repositories\EbayLegacyProductRepository;

class RefreshEbayLegacyProductsJob extends EbayJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected EbayIntegrationInstance $ebayIntegrationInstance,
        protected EbayGetLegacyProductsAdt $parameters,
    ) {
        $this->uniqueId = get_class($this).':'.$this->ebayIntegrationInstance->id;

        $this->isPageEnabledJob = true;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): EbayResponseData|ClientResponseDataInterface
    {
        if ($pageNumber = @$this->jobPayload['nextPage']) {
            $this->parameters->pageNumber = $pageNumber;
        }

        $lastCreatedDate = app(EbayLegacyProductRepository::class)->getStartDateForNew($this->ebayIntegrationInstance);

        // If no existing records, get all records
        if (!$lastCreatedDate) {
            $this->parameters->all = true;
        }

        if (!$this->parameters->all && is_null($this->parameters->created_after)) {
            $this->parameters->created_after = $lastCreatedDate;
            // TODO: This is a temporary fix and could lead to not retrieving all products.  I think we need a Generate job to dispatch jobs for all date ranges.  Read up on
            //  documentation before deciding.
            customlog('ebay', 'Using GetSellerList.  Last created date: '.$lastCreatedDate);
            $this->parameters->created_before = $lastCreatedDate->copy()->addDays(120);
        }
        else {
            customlog('ebay', 'Using GetMyEbaySelling');
        }

        return (new EbayLegacyProductManager($this->ebayIntegrationInstance))->refreshProducts($this->parameters);
    }
}
