<?php

namespace Modules\Ebay\Jobs;

use App\Models\SalesOrderFulfillment;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Exceptions\EbayOriginalSalesOrderLineDeletedException;
use Modules\Ebay\Managers\EbayOrderManager;

class EbayFulfillmentJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        private readonly EbayIntegrationInstance $integrationInstance,
        private readonly SalesOrderFulfillment $salesOrderFulfillment)
    {
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        try {
            (new EbayOrderManager($this->integrationInstance))->fulfillOrderForSalesOrderFulfillment($this->salesOrderFulfillment);
        } catch (EbayOriginalSalesOrderLineDeletedException) {
            return;
        }
    }
}
