<?php

declare(strict_types=1);

namespace Modules\Ebay\Jobs;

use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\Abstractions\EbayJob;
use Modules\Ebay\Managers\EbayLegacyProductManager;
use Throwable;

class CreateSkuProductsFromEbayProductsJob extends EbayJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected EbayIntegrationInstance $ebayIntegrationInstance,
    ) {
        $this->uniqueId = get_class($this).':'.$this->ebayIntegrationInstance->id;
    }

    /**
     * @throws Throwable
     */
    public function apiCall(): void
    {
        $ebayFulfillmentManager = new EbayLegacyProductManager(
            $this->ebayIntegrationInstance
        );
        $ebayFulfillmentManager->createSkuProducts([], true);
    }
}
